/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RouteModelsReloader
implements EventListener {
    private static final Log log = LogFactory.getLog(RouteModelsReloader.class);

    public boolean aboutToHandleEvent(Event event) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        if (!Framework.isDevModeSet()) {
            log.info((Object)"Do not flush the directory caches: dev mode is not set");
            return;
        }
        if (!"reload".equals(event.getId())) {
            return;
        }
        try {
            RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
            boolean txStarted = !TransactionHelper.isTransactionActive() && TransactionHelper.startTransaction();
            boolean txSucceed = false;
            try {
                new UnrestrictedSessionRunner(rm.getDefaultRepositoryName()){

                    public void run() {
                        DocumentRoutingService service = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
                        service.importAllRouteModels(this.session);
                    }
                }.runUnrestricted();
                txSucceed = true;
            }
            finally {
                if (txStarted) {
                    if (!txSucceed) {
                        TransactionHelper.setTransactionRollbackOnly();
                        log.warn((Object)"Rollbacking import of route models");
                    }
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        }
        catch (NuxeoException e) {
            log.error((Object)"Error while reloading the route models", (Throwable)e);
        }
    }
}

