/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.defaults;

import com.sun.jdmk.internal.ClassLogger;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DefaultPaths {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.misc", "DefaultPaths");
    private static String etcDir;
    private static String tmpDir;
    private static String installDir;

    private DefaultPaths() {
    }

    public static String getInstallDir() {
        logger.trace("getInstallDir", "starts");
        if (installDir == null) {
            return DefaultPaths.useCodeSource();
        }
        return installDir;
    }

    public static String getInstallDir(String dirname) {
        if (installDir == null) {
            if (dirname == null) {
                return DefaultPaths.getInstallDir();
            }
            return String.valueOf(DefaultPaths.getInstallDir()) + File.separator + dirname;
        }
        if (dirname == null) {
            return installDir;
        }
        return String.valueOf(installDir) + File.separator + dirname;
    }

    public static void setInstallDir(String dirname) {
        installDir = dirname;
    }

    public static String getEtcDir() {
        if (etcDir == null) {
            return DefaultPaths.getInstallDir("etc");
        }
        return etcDir;
    }

    public static String getEtcDir(String dirname) {
        if (etcDir == null) {
            if (dirname == null) {
                return DefaultPaths.getEtcDir();
            }
            return String.valueOf(DefaultPaths.getEtcDir()) + File.separator + dirname;
        }
        if (dirname == null) {
            return etcDir;
        }
        return String.valueOf(etcDir) + File.separator + dirname;
    }

    public static void setEtcDir(String dirname) {
        etcDir = dirname;
    }

    public static String getTmpDir() {
        if (tmpDir == null) {
            return DefaultPaths.getInstallDir("tmp");
        }
        return tmpDir;
    }

    public static String getTmpDir(String dirname) {
        if (tmpDir == null) {
            if (dirname == null) {
                return DefaultPaths.getTmpDir();
            }
            return String.valueOf(DefaultPaths.getTmpDir()) + File.separator + dirname;
        }
        if (dirname == null) {
            return tmpDir;
        }
        return String.valueOf(tmpDir) + File.separator + dirname;
    }

    public static void setTmpDir(String dirname) {
        tmpDir = dirname;
    }

    private static String useCodeSource() {
        block13: {
            try {
                String thisCodePath = null;
                try {
                    URL thisCodeLocation = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return DefaultPaths.class.getProtectionDomain().getCodeSource().getLocation();
                        }
                    });
                    if (thisCodeLocation.getProtocol().equalsIgnoreCase("file")) {
                        try {
                            thisCodePath = URLDecoder.decode(thisCodeLocation.getPath(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException x) {
                            logger.warning("useCodeSource", "Can't decode code base location: " + thisCodeLocation + "\n\t\tError is: " + x);
                            logger.finest("useCodeSource", x);
                        }
                    } else {
                        logger.warning("useCodeSource", "This code base location is not a file protocol URL: " + thisCodeLocation);
                    }
                    logger.fine("useCodeSource", "CodeBase=" + thisCodeLocation);
                    logger.fine("useCodeSource", "CodePath=" + thisCodePath);
                }
                catch (SecurityException se) {
                    logger.warning("useCodeSource", se);
                }
                if (thisCodePath == null) break block13;
                try {
                    boolean parentExists;
                    final File parent = new File(thisCodePath).getParentFile().getParentFile();
                    if (parent != null && (parentExists = ((Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return new Boolean(parent.exists());
                        }
                    })).booleanValue())) {
                        installDir = parent.getPath();
                    }
                }
                catch (SecurityException se) {
                    logger.warning("useCodeSource", se);
                }
            }
            catch (RuntimeException r) {
                logger.fine("useCodeSource", r);
            }
        }
        if (installDir == null) {
            logger.warning("getInstallDir", "Couldn't find JDMK install dir");
        } else {
            logger.config("getInstallDir", "JDMK_INSTALL_DIR=" + installDir);
        }
        return installDir;
    }
}

