/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;
import org.nuxeo.runtime.api.Framework;

public class SubscriptionAdapter {
    public static final String NOTIFIABLE_FACET = "Notifiable";
    private static final String NOTIF_PROPERTY = "notif:notifications";
    private static final String NOTIF_SUBSCRIBERSKEY = "subscribers";
    private static final String NOTIF_NAMEKEY = "name";
    private DocumentModel doc;

    public SubscriptionAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    private Map<String, Set<String>> getNotificationMap() {
        if (!this.doc.hasFacet(NOTIFIABLE_FACET)) {
            return new HashMap<String, Set<String>>();
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        List props = (List)((Object)this.doc.getPropertyValue(NOTIF_PROPERTY));
        for (Map prop : props) {
            String notificationName = (String)prop.get(NOTIF_NAMEKEY);
            String[] subscribers = (String[])prop.get(NOTIF_SUBSCRIBERSKEY);
            if (subscribers == null || subscribers.length <= 0) continue;
            if (!result.containsKey(notificationName)) {
                HashSet subscribersSet = new HashSet();
                result.put(notificationName, subscribersSet);
            }
            ((Set)result.get(notificationName)).addAll(Arrays.asList(subscribers));
        }
        return result;
    }

    private void setNotificationMap(Map<String, Set<String>> map) {
        ArrayList props = new ArrayList();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            Set<String> subscribers = entry.getValue();
            if (subscribers.isEmpty()) continue;
            HashMap<String, Object> propMap = new HashMap<String, Object>();
            propMap.put(NOTIF_NAMEKEY, entry.getKey());
            propMap.put(NOTIF_SUBSCRIBERSKEY, new ArrayList<String>(subscribers));
            props.add(propMap);
        }
        if (!props.isEmpty() && !this.doc.hasFacet(NOTIFIABLE_FACET)) {
            this.doc.addFacet(NOTIFIABLE_FACET);
        }
        this.doc.setPropertyValue(NOTIF_PROPERTY, (Serializable)props);
    }

    public List<String> getNotificationSubscribers(String notification) {
        Set<String> subscribers = this.getNotificationMap().get(notification);
        return subscribers != null ? new ArrayList<String>(subscribers) : Collections.emptyList();
    }

    public List<String> getUserSubscriptions(String username) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> entry : this.getNotificationMap().entrySet()) {
            if (!entry.getValue().contains(username)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public void addSubscription(String username, String notification) {
        Map<String, Set<String>> notificationMap = this.getNotificationMap();
        if (!notificationMap.containsKey(notification)) {
            notificationMap.put(notification, new HashSet());
        }
        notificationMap.get(notification).add(username);
        this.setNotificationMap(notificationMap);
    }

    public void addSubscriptionsToAll(String username) {
        HashSet<String> notificationNames = new HashSet<String>();
        NotificationManager ns = (NotificationManager)Framework.getLocalService(NotificationManager.class);
        for (Notification notif : ns.getNotificationsForSubscriptions(this.doc.getType())) {
            notificationNames.add(notif.getName());
        }
        CoreSession session = this.doc.getCoreSession();
        if (session != null) {
            for (DocumentModel parent : session.getParentDocuments(this.doc.getRef())) {
                for (Notification notif : ns.getNotificationsForSubscriptions(parent.getType())) {
                    notificationNames.add(notif.getName());
                }
            }
        }
        for (String name : notificationNames) {
            this.addSubscription(username, name);
        }
    }

    public void removeUserNotificationSubscription(String username, String notification) {
        Map<String, Set<String>> map = this.getNotificationMap();
        if (map.containsKey(notification)) {
            map.get(notification).remove(username);
        }
        this.setNotificationMap(map);
    }

    public void copySubscriptionsTo(DocumentModel targetDoc) {
        if (!targetDoc.hasFacet(NOTIFIABLE_FACET)) {
            targetDoc.addFacet(NOTIFIABLE_FACET);
        }
        targetDoc.setPropertyValue(NOTIF_PROPERTY, this.doc.getPropertyValue(NOTIF_PROPERTY));
    }
}

