/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.util.HashMap;
import java.util.Map;

public class Vars {
    public static Map<String, String> expand(Map<String, String> vars) {
        return Vars.expand(vars, null);
    }

    public static Map<String, String> expand(final Map<String, String> vars, final Resolver resolver) {
        final HashMap<String, String> result = new HashMap<String, String>(vars.size());
        Resolver resolver2 = new Resolver(){

            @Override
            public String get(String key) {
                String v = (String)result.get(key);
                if (v == null && (v = (String)vars.get(key)) == null && resolver != null) {
                    return resolver.get(key);
                }
                return v;
            }
        };
        for (Map.Entry<String, String> entry : vars.entrySet()) {
            String key = entry.getKey();
            String v = entry.getValue();
            if (v == null) {
                result.put(key, null);
                continue;
            }
            String rv = Vars.expand(v, resolver2);
            while (!rv.equals(v)) {
                v = rv;
                rv = Vars.expand(v, resolver2);
            }
            result.put(key, rv);
        }
        return result;
    }

    public static String expand(String expression, final Map<?, ?> vars) {
        int s = expression.indexOf("${", 0);
        if (s == -1) {
            return expression;
        }
        int e = expression.indexOf(125, s + 2);
        if (e == -1) {
            return expression;
        }
        return Vars.expand(expression, 0, s, e, new Resolver(){

            @Override
            public String get(String key) {
                Object v = vars.get(key);
                return v != null ? v.toString() : null;
            }
        });
    }

    public static String expand(String expression, Resolver resolver) {
        int s = expression.indexOf("${", 0);
        if (s == -1) {
            return expression;
        }
        int e = expression.indexOf(125, s + 2);
        if (e == -1) {
            return expression;
        }
        return Vars.expand(expression, 0, s, e, resolver);
    }

    private static String expand(String expression, int offset, int s, int e, Resolver resolver) {
        StringBuilder buf = new StringBuilder();
        do {
            String v;
            if (s > offset) {
                buf.append(expression.substring(offset, s));
            }
            if ((v = Vars.resolveVar(expression.substring(s + 2, e), resolver)) == null) {
                buf.append(expression.substring(s, e + 1));
                continue;
            }
            buf.append(v);
        } while ((s = expression.indexOf("${", offset = e + 1)) != -1 && (e = expression.indexOf(125, s + 2)) != -1);
        if (offset < expression.length()) {
            buf.append(expression.substring(offset));
        }
        return buf.toString();
    }

    private static final String resolveVar(String var, Resolver resolver) {
        String key = var;
        int i = var.indexOf(63);
        if (i > -1) {
            String v = resolver.get(key = key.substring(0, i));
            if (v != null) {
                return v.toString();
            }
            return var.substring(i + 1);
        }
        String v = resolver.get(key);
        return v != null ? v.toString() : null;
    }

    public static interface Resolver {
        public String get(String var1);
    }
}

