/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;

public class NuxeoValidationSupport {
    final Validation onBorrow;
    final Validation onReturn;
    static final Validation NOOP = new Validation(){

        @Override
        public boolean validate(Object handle) {
            return true;
        }
    };

    NuxeoValidationSupport(Validation onBorrow, Validation onReturn) {
        this.onBorrow = onBorrow == null ? NOOP : onBorrow;
        this.onReturn = onReturn == null ? NOOP : onReturn;
    }

    public ConnectionInterceptor addTransactionInterceptor(ConnectionInterceptor stack) {
        if (this.onBorrow == NOOP && this.onReturn == NOOP) {
            return stack;
        }
        return new ValidationHandleInterceptor(stack);
    }

    class ValidationHandleInterceptor
    implements ConnectionInterceptor {
        final ConnectionInterceptor next;

        public ValidationHandleInterceptor(ConnectionInterceptor next) {
            this.next = next;
        }

        public void getConnection(ConnectionInfo ci) throws ResourceException {
            ManagedConnectionInfo mci = ci.getManagedConnectionInfo();
            ManagedConnectionFactory mcf = mci.getManagedConnectionFactory();
            ConnectionRequestInfo cri = mci.getConnectionRequestInfo();
            while (true) {
                ConnectionInfo tryee = new ConnectionInfo(new ManagedConnectionInfo(mcf, cri));
                this.next.getConnection(tryee);
                Object handle = tryee.getConnectionProxy();
                if (handle == null) {
                    handle = tryee.getConnectionHandle();
                }
                if (NuxeoValidationSupport.this.onBorrow.validate(handle)) {
                    if (tryee.getConnectionProxy() != null) {
                        ci.setConnectionProxy(handle);
                    } else {
                        ci.setConnectionHandle(handle);
                    }
                    return;
                }
                LogFactory.getLog(NuxeoValidationSupport.class).warn((Object)("Returning invalid connection " + tryee));
                this.returnConnection(tryee, ConnectionReturnAction.DESTROY);
            }
        }

        public void returnConnection(ConnectionInfo info, ConnectionReturnAction returnAction) {
            if (returnAction == ConnectionReturnAction.RETURN_HANDLE && !NuxeoValidationSupport.this.onReturn.validate(info.getConnectionHandle())) {
                returnAction = ConnectionReturnAction.DESTROY;
            }
            this.next.returnConnection(info, returnAction);
        }

        public void info(StringBuilder s) {
            this.next.info(s);
        }

        public void destroy() {
            this.next.destroy();
        }
    }

    static class QuerySQLConnection
    implements Validation {
        final String sql;

        QuerySQLConnection(String sql) {
            this.sql = sql;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean validate(Object handle) {
            try (Statement statement = ((Connection)handle).unwrap(Connection.class).createStatement();){
                boolean bl = statement.execute(this.sql);
                return bl;
            }
            catch (SQLException cause) {
                LogFactory.getLog(QuerySQLConnection.class).warn((Object)String.format("Caught error executing '%s', invalidating", this.sql), (Throwable)cause);
                return false;
            }
        }
    }

    static class ValidSQLConnection
    implements Validation {
        ValidSQLConnection() {
        }

        @Override
        public boolean validate(Object handle) {
            try {
                return ((Connection)handle).isValid(0);
            }
            catch (SQLException cause) {
                return false;
            }
        }
    }

    static interface Validation {
        public boolean validate(Object var1);
    }
}

