/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.local;

import java.math.BigInteger;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.local.AbstractLocalService;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;

public class ObjectServiceImpl
extends AbstractLocalService
implements ObjectService {
    public ObjectServiceImpl(BindingSession session, CmisServiceFactory factory) {
        this.setSession(session);
        this.setServiceFactory(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                String string = null;
                return string;
            }
            String serviceResult = service.createDocument(repositoryId, properties, folderId, contentStream, versioningState, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                String string = null;
                return string;
            }
            String string = serviceResult;
            return string;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                String string = null;
                return string;
            }
            String serviceResult = service.createDocumentFromSource(repositoryId, sourceId, properties, folderId, versioningState, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                String string = null;
                return string;
            }
            String string = serviceResult;
            return string;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                String string = null;
                return string;
            }
            String serviceResult = service.createFolder(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                String string = null;
                return string;
            }
            String string = serviceResult;
            return string;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                String string = null;
                return string;
            }
            String serviceResult = service.createPolicy(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                String string = null;
                return string;
            }
            String string = serviceResult;
            return string;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createItem(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                String string = null;
                return string;
            }
            String serviceResult = service.createItem(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                String string = null;
                return string;
            }
            String string = serviceResult;
            return string;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                String string = null;
                return string;
            }
            String serviceResult = service.createRelationship(repositoryId, properties, policies, addAces, removeAces, extension);
            if (this.stopAfterService(service)) {
                String string = null;
                return string;
            }
            String string = serviceResult;
            return string;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                return;
            }
            service.deleteContentStream(repositoryId, objectId, changeToken, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                return;
            }
            service.deleteObject(repositoryId, objectId, allVersions, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                FailedToDeleteData failedToDeleteData = null;
                return failedToDeleteData;
            }
            FailedToDeleteData serviceResult = service.deleteTree(repositoryId, folderId, allVersions, unfileObjects, continueOnFailure, extension);
            if (this.stopAfterService(service)) {
                FailedToDeleteData failedToDeleteData = null;
                return failedToDeleteData;
            }
            FailedToDeleteData failedToDeleteData = serviceResult;
            return failedToDeleteData;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                AllowableActions allowableActions = null;
                return allowableActions;
            }
            AllowableActions serviceResult = service.getAllowableActions(repositoryId, objectId, extension);
            if (this.stopAfterService(service)) {
                AllowableActions allowableActions = null;
                return allowableActions;
            }
            AllowableActions allowableActions = serviceResult;
            return allowableActions;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                ContentStream contentStream = null;
                return contentStream;
            }
            ContentStream serviceResult = service.getContentStream(repositoryId, objectId, streamId, offset, length, extension);
            if (this.stopAfterService(service)) {
                ContentStream contentStream = null;
                return contentStream;
            }
            ContentStream contentStream = serviceResult;
            return contentStream;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                ObjectData objectData = null;
                return objectData;
            }
            ObjectData serviceResult = service.getObject(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
            if (this.stopAfterService(service)) {
                ObjectData objectData = null;
                return objectData;
            }
            ObjectData objectData = serviceResult;
            return objectData;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                ObjectData objectData = null;
                return objectData;
            }
            ObjectData serviceResult = service.getObjectByPath(repositoryId, path, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
            if (this.stopAfterService(service)) {
                ObjectData objectData = null;
                return objectData;
            }
            ObjectData objectData = serviceResult;
            return objectData;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                Properties properties = null;
                return properties;
            }
            Properties serviceResult = service.getProperties(repositoryId, objectId, filter, extension);
            if (this.stopAfterService(service)) {
                Properties properties = null;
                return properties;
            }
            Properties properties = serviceResult;
            return properties;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                List<RenditionData> list = null;
                return list;
            }
            List serviceResult = service.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, extension);
            if (this.stopAfterService(service)) {
                List<RenditionData> list = null;
                return list;
            }
            List list = serviceResult;
            return list;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                return;
            }
            service.moveObject(repositoryId, objectId, targetFolderId, sourceFolderId, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                return;
            }
            service.setContentStream(repositoryId, objectId, overwriteFlag, changeToken, contentStream, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                return;
            }
            service.appendContentStream(repositoryId, objectId, changeToken, contentStream, isLastChunk, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                return;
            }
            service.updateProperties(repositoryId, objectId, changeToken, properties, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            if (this.stopBeforeService(service)) {
                List<BulkUpdateObjectIdAndChangeToken> list = null;
                return list;
            }
            List serviceResult = service.bulkUpdateProperties(repositoryId, objectIdAndChangeToken, properties, addSecondaryTypeIds, removeSecondaryTypeIds, extension);
            if (this.stopAfterService(service)) {
                List<BulkUpdateObjectIdAndChangeToken> list = null;
                return list;
            }
            List list = serviceResult;
            return list;
        }
        finally {
            service.close();
        }
    }
}

