/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.localfs;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.helper.VersioningHelper;
import org.nuxeo.ecm.platform.publisher.impl.localfs.NotFSPublishedDocumentException;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.CoreIODocumentModelMarshaler;

public class FSPublishedDocument
implements PublishedDocument {
    private static final long serialVersionUID = 1L;
    public static final Namespace nxfspub = new Namespace("nxfspub", "http://www.nuxeo.org/publisher/filesystem");
    public static final QName pubInfoQN = DocumentFactory.getInstance().createQName("publicationInfo", nxfspub);
    public static final QName sourceDocRefQN = DocumentFactory.getInstance().createQName("sourceDocumentRef", nxfspub);
    public static final QName sourceRepositoryNameQN = DocumentFactory.getInstance().createQName("sourceRepositoryName", nxfspub);
    public static final QName sourceServerQN = DocumentFactory.getInstance().createQName("sourceServer", nxfspub);
    public static final QName sourceVersionQN = DocumentFactory.getInstance().createQName("sourceVersion", nxfspub);
    public static final QName isPendingQN = DocumentFactory.getInstance().createQName("isPending", nxfspub);
    protected DocumentRef sourceDocumentRef;
    protected String sourceRepositoryName;
    protected String sourceServer;
    protected String sourceVersion;
    protected String persistPath;
    protected String parentPath;
    protected boolean isPending;
    protected String xmlRepresentation;

    public FSPublishedDocument(File file) throws NotFSPublishedDocumentException {
        this.parseXML(file);
        this.persistPath = file.getAbsolutePath();
        this.parentPath = file.getParent();
    }

    protected void parseXML(File file) throws NotFSPublishedDocumentException {
        SAXReader xmlReader = new SAXReader();
        try {
            Document doc = xmlReader.read(file);
            Element info = doc.getRootElement().element(pubInfoQN);
            if (info == null) {
                throw new NotFSPublishedDocumentException();
            }
            this.sourceDocumentRef = new IdRef(info.element(sourceDocRefQN).getTextTrim());
            this.sourceRepositoryName = info.element(sourceRepositoryNameQN).getTextTrim();
            this.sourceServer = info.element(sourceServerQN).getTextTrim();
            this.sourceVersion = info.element(sourceVersionQN).getTextTrim();
            this.isPending = Boolean.parseBoolean(info.element(isPendingQN).getTextTrim());
        }
        catch (DocumentException e) {
            throw new NotFSPublishedDocumentException(e);
        }
    }

    public void persist(String containerPath) throws IOException {
        File output = new File(containerPath, this.sourceDocumentRef.toString());
        FileUtils.writeFile((File)output, (String)this.xmlRepresentation);
        this.persistPath = output.getAbsolutePath();
    }

    public FSPublishedDocument(String server, DocumentModel doc) throws DocumentException {
        this(server, doc, false);
    }

    public FSPublishedDocument(String server, DocumentModel doc, boolean isPending) throws DocumentException {
        this.sourceRepositoryName = doc.getRepositoryName();
        this.sourceDocumentRef = doc.getRef();
        this.sourceVersion = VersioningHelper.getVersionLabelFor(doc);
        this.sourceServer = server;
        this.isPending = isPending;
        CoreIODocumentModelMarshaler marshaler = new CoreIODocumentModelMarshaler();
        String xmlDoc = marshaler.marshalDocument(doc);
        SAXReader xmlReader = new SAXReader();
        Document xml = xmlReader.read((Reader)new StringReader(xmlDoc));
        xml.getRootElement().add(nxfspub);
        Element info = xml.getRootElement().addElement(pubInfoQN);
        info.addElement(sourceDocRefQN).setText(this.sourceDocumentRef.toString());
        info.addElement(sourceRepositoryNameQN).setText(this.sourceRepositoryName);
        if (this.sourceServer != null) {
            info.addElement(sourceServerQN).setText(this.sourceServer);
        } else {
            info.addElement(sourceServerQN);
        }
        if (this.sourceVersion != null) {
            info.addElement(sourceVersionQN).setText(this.sourceVersion);
        } else {
            info.addElement(sourceVersionQN);
        }
        info.addElement(isPendingQN).setText(String.valueOf(isPending));
        this.xmlRepresentation = xml.asXML();
    }

    public DocumentRef getSourceDocumentRef() {
        return this.sourceDocumentRef;
    }

    public String getSourceRepositoryName() {
        return this.sourceRepositoryName;
    }

    public String getSourceServer() {
        return this.sourceServer;
    }

    public String getSourceVersionLabel() {
        return this.sourceVersion;
    }

    public String getPersistPath() {
        return this.persistPath;
    }

    public String getPath() {
        return this.getPersistPath();
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public boolean isPending() {
        return this.isPending;
    }

    public PublishedDocument.Type getType() {
        return PublishedDocument.Type.FILE_SYSTEM;
    }
}

