/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickSort {
    private static final Comparator<? extends Comparable> objComp = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable object1, Comparable object2) {
            return object1.compareTo(object2);
        }
    };

    private QuickSort() {
    }

    public static <T> void sort(List<T> list, Comparator<T> cmp) {
        int size = list.size();
        if (size < 2) {
            return;
        }
        QuickSort.quicksort(list, cmp, 0, size - 1);
    }

    public static <T extends Comparable> void sort(List<T> list) {
        QuickSort.sort(list, objComp);
    }

    private static <T> void quicksort(List<T> list, Comparator<T> cmp, int left, int right) {
        if (left < right) {
            int splitter = QuickSort.split(list, cmp, left, right);
            QuickSort.quicksort(list, cmp, left, splitter - 1);
            QuickSort.quicksort(list, cmp, splitter + 1, right);
        }
    }

    private static <T> void swap(List<T> list, int i, int j) {
        T tmp = list.get(i);
        list.set(i, list.get(j));
        list.set(j, tmp);
    }

    private static <T> int split(List<T> list, Comparator<T> cmp, int left, int right) {
        int i = left;
        int j = right - 1;
        T pivot = list.get(right);
        while (true) {
            if (cmp.compare(list.get(i), pivot) <= 0 && i < right) {
                ++i;
                continue;
            }
            while (cmp.compare(pivot, list.get(j)) <= 0 && j > left) {
                --j;
            }
            if (i < j) {
                QuickSort.swap(list, i, j);
            }
            if (i >= j) break;
        }
        if (cmp.compare(pivot, list.get(i)) < 0) {
            QuickSort.swap(list, i, right);
        }
        return i;
    }
}

