/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.bindings;

import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.server.shared.CsrfManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.opencmis.bindings.CXFAuthHandler;
import org.nuxeo.ecm.core.opencmis.bindings.LoginProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.Authenticator;

public class NuxeoCmisAuthHandler
extends CXFAuthHandler
implements LoginProvider {
    public static final String NUXEO_LOGIN_CONTEXT = "nuxeo.opencmis.LoginContext";
    private static final Log log = LogFactory.getLog(NuxeoCmisAuthHandler.class);
    protected LoginProvider loginProvider;
    protected CsrfManager csrfManager = new CsrfManager(null, null);

    @Override
    public boolean handleMessage(SOAPMessageContext context) {
        boolean res = super.handleMessage(context);
        HttpServletRequest request = (HttpServletRequest)context.get((Object)"javax.xml.ws.servlet.request");
        request.setAttribute("org.apache.chemistry.opencmis.cmisVersion", (Object)CmisVersion.CMIS_1_1);
        request.setAttribute("org.apache.chemistry.opencmis.csrfManager", (Object)this.csrfManager);
        Map callContextMap = (Map)context.get((Object)"org.apache.chemistry.opencmis.callcontext");
        if (callContextMap != null) {
            String username = (String)callContextMap.get("username");
            String password = (String)callContextMap.get("password");
            try {
                LoginContext loginContext = this.getLoginProvider().login(username, password);
                context.put((Object)NUXEO_LOGIN_CONTEXT, (Object)loginContext);
                context.setScope(NUXEO_LOGIN_CONTEXT, MessageContext.Scope.APPLICATION);
            }
            catch (LoginException e) {
                throw new RuntimeException("Login failed for user '" + username + "'", e);
            }
        }
        return res;
    }

    @Override
    public void close(MessageContext context) {
        LoginContext loginContext = (LoginContext)context.get((Object)NUXEO_LOGIN_CONTEXT);
        if (loginContext != null) {
            try {
                loginContext.logout();
            }
            catch (LoginException e) {
                log.error((Object)"Cannot logout", (Throwable)e);
            }
        }
        super.close(context);
    }

    protected LoginProvider getLoginProvider() {
        if (this.loginProvider == null) {
            this.loginProvider = this;
            String className = Framework.getProperty((String)LoginProvider.class.getName());
            if (className != null) {
                try {
                    Object instance = Class.forName(className).newInstance();
                    if (instance instanceof LoginProvider) {
                        this.loginProvider = (LoginProvider)instance;
                    } else {
                        log.error((Object)(className + " is not an instance of " + LoginProvider.class.getName()));
                    }
                }
                catch (ReflectiveOperationException e) {
                    log.error((Object)e);
                }
            }
        }
        return this.loginProvider;
    }

    @Override
    public LoginContext login(String username, String password) {
        try {
            if (!NuxeoCmisAuthHandler.getAuthenticator().checkUsernamePassword(username, password)) {
                throw new RuntimeException("Authentication failed for user '" + username + "'");
            }
            return Framework.login((String)username, (Object)password);
        }
        catch (LoginException e) {
            throw new RuntimeException("Login failed for user '" + username + "'", e);
        }
    }

    protected static Authenticator getAuthenticator() {
        return (Authenticator)Framework.getService(Authenticator.class);
    }
}

