/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.collections.api.FavoritesManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;

@Operation(id="Document.RemoveFromFavorites", category="Document", label="Remove from favorites", description="Remove a list of documents from the favorites. No value is returned.", aliases={"Collection.RemoveFromFavorites"})
public class RemoveFromFavoritesOperation {
    public static final String ID = "Document.RemoveFromFavorites";
    @Context
    protected CoreSession session;
    @Context
    protected FavoritesManager favoritesManager;

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) {
        for (DocumentModel doc : docs) {
            this.favoritesManager.removeFromFavorites(doc, this.session);
        }
        return docs;
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        this.favoritesManager.removeFromFavorites(doc, this.session);
        return doc;
    }
}

