/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.io;

import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class CollectionsJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "collections";

    public CollectionsJsonEnricher() {
        super(NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        jg.writeFieldName(NAME);
        jg.writeStartArray();
        CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            List<DocumentModel> collections = collectionManager.getVisibleCollection(document, wrapper.getSession());
            for (DocumentModel collection : collections) {
                this.writeEntity(collection, jg);
            }
        }
        finally {
            jg.writeEndArray();
        }
    }
}

