/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.worker;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.collections.core.adapter.Collection;
import org.nuxeo.ecm.collections.core.worker.RemovedAbstractWork;
import org.nuxeo.ecm.core.api.DocumentModel;

public class RemovedCollectionMemberWork
extends RemovedAbstractWork {
    private static final Log log = LogFactory.getLog(RemovedCollectionMemberWork.class);
    private static final long serialVersionUID = 6944563540430297431L;
    public static final String CATEGORY = "removedCollectionMember";
    protected static final String TITLE = "Remove CollectionMember Work";

    public RemovedCollectionMemberWork() {
    }

    protected RemovedCollectionMemberWork(long offset) {
        super(offset);
    }

    public String getTitle() {
        return TITLE;
    }

    public String getCategory() {
        return CATEGORY;
    }

    @Override
    protected String getQuery() {
        return "SELECT * FROM Document WHERE collection:documentIds/* = ?";
    }

    @Override
    protected void updateDocument(DocumentModel collection) {
        log.trace((Object)String.format("Worker %s, updating Collection %s", this.getId(), collection.getTitle()));
        Collection collectionAdapter = (Collection)collection.getAdapter(Collection.class);
        collectionAdapter.removeDocument(this.docId);
        this.session.saveDocument(collection);
    }
}

