/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.platform.usermanager.UserConfig;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class NuxeoPrincipalImpl
implements NuxeoPrincipal {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NuxeoPrincipalImpl.class);
    protected UserConfig config = UserConfig.DEFAULT;
    public final List<String> roles = new LinkedList<String>();
    public List<String> virtualGroups = new LinkedList<String>();
    public List<String> allGroups;
    public final boolean isAnonymous;
    public boolean isAdministrator;
    public String principalId;
    public DocumentModel model;
    public DataModel dataModel;
    public String origUserName;

    public NuxeoPrincipalImpl(String name) {
        this(name, false, false);
    }

    public NuxeoPrincipalImpl(String name, boolean isAnonymous) {
        this(name, isAnonymous, false);
    }

    public NuxeoPrincipalImpl(String name, boolean isAnonymous, boolean isAdministrator) {
        this(name, isAnonymous, isAdministrator, true);
    }

    public NuxeoPrincipalImpl(String name, boolean isAnonymous, boolean isAdministrator, boolean updateAllGroups) {
        DocumentModelImpl documentModelImpl = new DocumentModelImpl(this.config.schemaName);
        documentModelImpl.addDataModel((DataModel)new DataModelImpl(this.config.schemaName, new HashMap()));
        this.setModel((DocumentModel)documentModelImpl, updateAllGroups);
        this.dataModel.setData(this.config.nameKey, (Object)name);
        this.isAnonymous = isAnonymous;
        this.isAdministrator = isAdministrator;
    }

    protected NuxeoPrincipalImpl(NuxeoPrincipalImpl other) {
        this.config = other.config;
        try {
            this.model = other.model.clone();
        }
        catch (CloneNotSupportedException cause) {
            throw new NuxeoException("Cannot clone principal " + this);
        }
        this.dataModel = this.model.getDataModel(this.config.schemaName);
        this.roles.addAll(other.roles);
        this.allGroups = new ArrayList<String>(other.allGroups);
        this.virtualGroups = new ArrayList<String>(other.virtualGroups);
        this.isAdministrator = other.isAdministrator;
        this.isAnonymous = other.isAnonymous;
        this.origUserName = other.origUserName;
        this.principalId = other.principalId;
    }

    public void setConfig(UserConfig config) {
        this.config = config;
    }

    public UserConfig getConfig() {
        return this.config;
    }

    public String getCompany() {
        try {
            return (String)this.dataModel.getData(this.config.companyKey);
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public void setCompany(String company) {
        this.dataModel.setData(this.config.companyKey, (Object)company);
    }

    public String getFirstName() {
        try {
            return (String)this.dataModel.getData(this.config.firstNameKey);
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public void setFirstName(String firstName) {
        this.dataModel.setData(this.config.firstNameKey, (Object)firstName);
    }

    public String getLastName() {
        try {
            return (String)this.dataModel.getData(this.config.lastNameKey);
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public void setLastName(String lastName) {
        this.dataModel.setData(this.config.lastNameKey, (Object)lastName);
    }

    public void setName(String name) {
        this.dataModel.setData(this.config.nameKey, (Object)name);
    }

    public void setRoles(List<String> roles) {
        this.roles.clear();
        this.roles.addAll(roles);
    }

    public void setGroups(List<String> groups) {
        if (this.virtualGroups != null && !this.virtualGroups.isEmpty()) {
            ArrayList<String> groupsToWrite = new ArrayList<String>();
            for (String group : groups) {
                if (this.virtualGroups.contains(group)) continue;
                groupsToWrite.add(group);
            }
            this.dataModel.setData(this.config.groupsKey, groupsToWrite);
        } else {
            this.dataModel.setData(this.config.groupsKey, groups);
        }
    }

    public String getName() {
        try {
            return (String)this.dataModel.getData(this.config.nameKey);
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public List<String> getGroups() {
        List storedGroups;
        LinkedList<String> groups = new LinkedList<String>();
        try {
            storedGroups = (List)this.dataModel.getData(this.config.groupsKey);
        }
        catch (PropertyException e) {
            return null;
        }
        if (storedGroups != null) {
            groups.addAll(storedGroups);
        }
        groups.addAll(this.virtualGroups);
        return groups;
    }

    @Deprecated
    public List<String> getRoles() {
        return new ArrayList<String>(this.roles);
    }

    public void setPassword(String password) {
        this.dataModel.setData(this.config.passwordKey, (Object)password);
    }

    public String getPassword() {
        return null;
    }

    public String toString() {
        return (String)this.dataModel.getData(this.config.nameKey);
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public String getEmail() {
        try {
            return (String)this.dataModel.getData(this.config.emailKey);
        }
        catch (PropertyException e) {
            return null;
        }
    }

    public void setEmail(String email) {
        this.dataModel.setData(this.config.emailKey, (Object)email);
    }

    public DocumentModel getModel() {
        return this.model;
    }

    public void setModel(DocumentModel model, boolean updateAllGroups) {
        this.model = model;
        this.dataModel = (DataModel)model.getDataModels().values().iterator().next();
        if (updateAllGroups) {
            this.updateAllGroups();
        }
    }

    public void setModel(DocumentModel model) {
        this.setModel(model, true);
    }

    public boolean isMemberOf(String group) {
        return this.allGroups.contains(group);
    }

    public List<String> getAllGroups() {
        return new ArrayList<String>(this.allGroups);
    }

    public void updateAllGroups() {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        HashSet<String> checkedGroups = new HashSet<String>();
        ArrayList<String> groupsToProcess = new ArrayList<String>();
        ArrayList<String> resultingGroups = new ArrayList<String>();
        groupsToProcess.addAll(this.getGroups());
        while (!groupsToProcess.isEmpty()) {
            String groupName = (String)groupsToProcess.remove(0);
            if (checkedGroups.contains(groupName)) continue;
            checkedGroups.add(groupName);
            NuxeoGroup nxGroup = null;
            if (userManager != null) {
                try {
                    nxGroup = userManager.getGroup(groupName);
                }
                catch (DirectoryException de) {
                    if (this.virtualGroups.contains(groupName)) {
                        log.warn((Object)("Failed to get group '" + groupName + "' due to '" + de.getMessage() + "': permission resolution involving groups may not be correct"));
                        nxGroup = null;
                    }
                    throw de;
                }
            }
            if (nxGroup == null) {
                if (this.virtualGroups.contains(groupName)) {
                    resultingGroups.add(groupName);
                    continue;
                }
                if (userManager == null) continue;
                log.error((Object)("User " + this.getName() + " references the " + groupName + " group that does not exists"));
                continue;
            }
            groupsToProcess.addAll(nxGroup.getParentGroups());
            resultingGroups.add(nxGroup.getName());
        }
        this.allGroups = new ArrayList<String>(resultingGroups);
        if (!this.isAdministrator() && userManager != null) {
            List<String> adminGroups = userManager.getAdministratorsGroups();
            for (String adminGroup : adminGroups) {
                if (!this.allGroups.contains(adminGroup)) continue;
                this.isAdministrator = true;
                break;
            }
        }
    }

    public List<String> getVirtualGroups() {
        return new ArrayList<String>(this.virtualGroups);
    }

    public void setVirtualGroups(List<String> virtualGroups, boolean updateAllGroups) {
        this.virtualGroups = new ArrayList<String>(virtualGroups);
        if (updateAllGroups) {
            this.updateAllGroups();
        }
    }

    public void setVirtualGroups(List<String> virtualGroups) {
        this.setVirtualGroups(virtualGroups, true);
    }

    public boolean isAdministrator() {
        return this.isAdministrator || "system".equals(this.getName());
    }

    public String getTenantId() {
        return null;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean equals(Object other) {
        if (other instanceof Principal) {
            String name = this.getName();
            String otherName = ((Principal)other).getName();
            if (name == null) {
                return otherName == null;
            }
            return name.equals(otherName);
        }
        return false;
    }

    public int hashCode() {
        String name = this.getName();
        return name == null ? 0 : name.hashCode();
    }

    public String getOriginatingUser() {
        return this.origUserName;
    }

    public void setOriginatingUser(String originatingUser) {
        this.origUserName = originatingUser;
    }

    public String getActingUser() {
        return this.getOriginatingUser() == null ? this.getName() : this.getOriginatingUser();
    }

    public boolean isTransient() {
        String name = this.getName();
        return name != null && name.startsWith("transient/");
    }

    protected NuxeoPrincipal cloneTransferable() {
        return new TransferableClone(this);
    }

    protected static class TransferableClone
    extends NuxeoPrincipalImpl {
        protected TransferableClone(NuxeoPrincipalImpl other) {
            super(other);
        }

        private Object writeReplace() throws ObjectStreamException {
            return new DataTransferObject(this);
        }

        static class DataTransferObject
        implements Serializable {
            private static final long serialVersionUID = 1L;
            final String username;
            final String originatingUser;

            DataTransferObject(NuxeoPrincipal principal) {
                this.username = principal.getName();
                this.originatingUser = principal.getOriginatingUser();
            }

            private Object readResolve() throws ObjectStreamException {
                NuxeoPrincipal principal = ((UserManager)Framework.getService(UserManager.class)).getPrincipal(this.username);
                principal.setOriginatingUser(this.originatingUser);
                return principal;
            }
        }
    }
}

