/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.scripting;

import groovy.lang.GroovyRuntimeException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.loader.WebLoader;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;

public class Scripting {
    private static final Log log = LogFactory.getLog(Scripting.class);
    private final ConcurrentMap<File, Entry> cache = new ConcurrentHashMap<File, Entry>();
    private ScriptEngineManager scriptMgr;
    private final WebLoader loader;

    public Scripting(WebLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompiledScript compileScript(ScriptEngine engine, File file) throws ScriptException {
        if (engine instanceof Compilable) {
            CompiledScript compiledScript;
            Compilable comp = (Compilable)((Object)engine);
            FileReader reader = new FileReader(file);
            try {
                compiledScript = comp.compile(reader);
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ScriptException(e);
                }
            }
            ((Reader)reader).close();
            return compiledScript;
        }
        return null;
    }

    public ScriptEngineManager getEngineManager() {
        if (this.scriptMgr == null) {
            this.scriptMgr = new ScriptEngineManager();
        }
        return this.scriptMgr;
    }

    public boolean isScript(String ext) {
        return this.getEngineManager().getEngineByExtension(ext) != null;
    }

    public Object runScript(ScriptFile script) throws ScriptException {
        return this.runScript(script, null);
    }

    public Object runScript(ScriptFile script, Map<String, Object> args) throws ScriptException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("## Running Script: " + script.getFile()));
        }
        if ("groovy".equals(script.getExtension())) {
            try {
                return this.loader.getGroovyScripting().eval(script.file, args);
            }
            catch (GroovyRuntimeException e) {
                throw new ScriptException((Exception)((Object)e));
            }
        }
        return this._runScript(script, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _runScript(ScriptFile script, Map<String, Object> args) throws ScriptException {
        SimpleBindings bindings = new SimpleBindings();
        if (args != null) {
            bindings.putAll((Map<? extends String, ? extends Object>)args);
        }
        String ext = script.getExtension();
        ScriptEngine engine = this.getEngineManager().getEngineByExtension(ext);
        if (engine != null) {
            Object object;
            SimpleScriptContext ctx = new SimpleScriptContext();
            ctx.setBindings(bindings, 100);
            CompiledScript comp = this.getCompiledScript(engine, script.getFile());
            if (comp != null) {
                return comp.eval(ctx);
            }
            FileReader reader = new FileReader(script.getFile());
            try {
                Object result = engine.eval((Reader)reader, (ScriptContext)ctx);
                if (result == null) {
                    result = bindings.get("__result__");
                }
                object = result;
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ScriptException(e);
                }
            }
            ((Reader)reader).close();
            return object;
        }
        return null;
    }

    public CompiledScript getCompiledScript(ScriptEngine engine, File file) throws ScriptException {
        Entry entry = (Entry)this.cache.get(file);
        long tm = file.lastModified();
        if (entry != null) {
            if (entry.lastModified < tm) {
                entry.script = Scripting.compileScript(engine, file);
                entry.lastModified = tm;
            }
            return entry.script;
        }
        CompiledScript script = Scripting.compileScript(engine, file);
        if (script != null) {
            this.cache.putIfAbsent(file, new Entry(script, tm));
            return script;
        }
        return null;
    }

    class Entry {
        public CompiledScript script;
        public long lastModified;

        Entry(CompiledScript script, long lastModified) {
            this.lastModified = lastModified;
            this.script = script;
        }
    }
}

