/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.cache.AbstractCache;
import org.nuxeo.ecm.core.cache.CacheDescriptor;

public class InMemoryCacheImpl
extends AbstractCache {
    protected static final Log log = LogFactory.getLog(InMemoryCacheImpl.class);
    protected final Cache<String, Serializable> cache;

    public InMemoryCacheImpl(CacheDescriptor desc) {
        super(desc);
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder = builder.expireAfterWrite((long)desc.ttl, TimeUnit.MINUTES);
        if (desc.options.containsKey("concurrencyLevel")) {
            builder = builder.concurrencyLevel(Integer.valueOf(desc.options.get("concurrencyLevel")).intValue());
        }
        if (desc.options.containsKey("maxSize")) {
            builder = builder.maximumSize((long)Integer.valueOf(desc.options.get("maxSize")).intValue());
        }
        this.cache = builder.build();
    }

    public Cache<String, Serializable> getGuavaCache() {
        return this.cache;
    }

    @Override
    public Serializable get(String key) {
        if (key == null) {
            return null;
        }
        return (Serializable)this.cache.getIfPresent((Object)key);
    }

    @Override
    public Set<String> keySet() {
        return this.cache.asMap().keySet();
    }

    @Override
    public void invalidate(String key) {
        if (key != null) {
            this.cache.invalidate((Object)key);
        } else {
            log.warn((Object)String.format("Can't invalidate a null key for the cache '%s'!", this.name));
        }
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public void put(String key, Serializable value) {
        if (key != null && value != null) {
            this.cache.put((Object)key, (Object)value);
        } else {
            log.warn((Object)String.format("Can't put a null key nor a null value in the cache '%s'!", this.name));
        }
    }

    @Override
    public boolean hasEntry(String key) {
        return this.cache.asMap().containsKey(key);
    }
}

