/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.transientstore.api.MaximumTransientSpaceExceeded;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreConfig;

public abstract class AbstractTransientStore
implements TransientStore {
    protected static final Log log = LogFactory.getLog(AbstractTransientStore.class);
    protected TransientStoreConfig config;
    protected File cacheDir;

    @Override
    public void init(TransientStoreConfig config) {
        this.config = config;
        File transienStoreHome = new File(Environment.getDefault().getData(), "transientstores");
        File data = new File(transienStoreHome, config.getName());
        data.mkdirs();
        this.cacheDir = data.getAbsoluteFile();
    }

    @Override
    public abstract void shutdown();

    @Override
    public abstract boolean exists(String var1);

    @Override
    public abstract Set<String> keySet();

    @Override
    public abstract void putParameter(String var1, String var2, Serializable var3);

    @Override
    public abstract Serializable getParameter(String var1, String var2);

    @Override
    public abstract void putParameters(String var1, Map<String, Serializable> var2);

    @Override
    public abstract Map<String, Serializable> getParameters(String var1);

    @Override
    public abstract List<Blob> getBlobs(String var1);

    @Override
    public abstract long getSize(String var1);

    @Override
    public abstract boolean isCompleted(String var1);

    @Override
    public abstract void setCompleted(String var1, boolean var2);

    @Override
    public abstract void remove(String var1);

    @Override
    public abstract void release(String var1);

    protected abstract void persistBlobs(String var1, long var2, List<Map<String, String>> var4);

    public abstract long getStorageSize();

    protected abstract void setStorageSize(long var1);

    protected abstract long incrementStorageSize(long var1);

    protected abstract long decrementStorageSize(long var1);

    protected abstract void removeAllEntries();

    @Override
    public void putBlobs(String key, List<Blob> blobs) {
        if (this.config.getAbsoluteMaxSizeMB() >= 0 && this.getStorageSize() >= (long)(this.config.getAbsoluteMaxSizeMB() * 0x100000)) {
            throw new MaximumTransientSpaceExceeded();
        }
        List<Map<String, String>> blobInfos = this.storeBlobs(key, blobs);
        this.persistBlobs(key, this.getSizeOfBlobs(blobs), blobInfos);
    }

    protected List<Map<String, String>> storeBlobs(String key, List<Blob> blobs) {
        if (blobs == null) {
            return null;
        }
        ArrayList<Map<String, String>> blobInfos = new ArrayList<Map<String, String>>();
        for (Blob blob : blobs) {
            HashMap<String, String> blobInfo = new HashMap<String, String>();
            File cachingDir = this.getCachingDirectory(key);
            String uuid = UUID.randomUUID().toString();
            File cachedFile = new File(cachingDir, uuid);
            try {
                if (blob instanceof FileBlob && ((FileBlob)blob).isTemporary()) {
                    ((FileBlob)blob).moveTo(cachedFile);
                } else {
                    blob.transferTo(cachedFile);
                }
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
            Path cachedFileRelativePath = Paths.get(cachingDir.getName(), uuid);
            blobInfo.put("file", cachedFileRelativePath.toString());
            if (blob.getFilename() != null) {
                blobInfo.put("filename", blob.getFilename());
            }
            if (blob.getEncoding() != null) {
                blobInfo.put("encoding", blob.getEncoding());
            }
            if (blob.getMimeType() != null) {
                blobInfo.put("mimetype", blob.getMimeType());
            }
            if (blob.getDigest() != null) {
                blobInfo.put("digest", blob.getDigest());
            }
            blobInfos.add(blobInfo);
        }
        log.debug((Object)("Stored blobs on the file system: " + blobInfos));
        return blobInfos;
    }

    public File getCachingDirectory(String key) {
        try {
            File cachingDir = new File(this.cacheDir.getCanonicalFile(), this.getCachingDirName(key));
            if (!cachingDir.getCanonicalPath().startsWith(this.cacheDir.getCanonicalPath())) {
                throw new SecurityException("Trying to traverse illegal path");
            }
            if (!cachingDir.exists()) {
                cachingDir.mkdir();
            }
            return cachingDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Error when trying to access cache directory");
        }
    }

    protected String getCachingDirName(String key) {
        String dirName = Base64.encodeBase64String((byte[])key.getBytes());
        dirName = dirName.replaceAll("/", "_");
        return dirName;
    }

    protected long getSizeOfBlobs(List<Blob> blobs) {
        int size = 0;
        if (blobs != null) {
            for (Blob blob : blobs) {
                long blobLength = blob.getLength();
                if (blobLength <= -1L) continue;
                size = (int)((long)size + blobLength);
            }
        }
        return size;
    }

    protected List<Blob> loadBlobs(List<Map<String, String>> blobInfos) {
        log.debug((Object)("Loading blobs from the file system: " + blobInfos));
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (Map<String, String> info : blobInfos) {
            File blobFile = new File(this.cacheDir, info.get("file"));
            FileBlob blob = new FileBlob(blobFile);
            blob.setEncoding(info.get("encoding"));
            blob.setMimeType(info.get("mimetype"));
            blob.setFilename(info.get("filename"));
            blob.setDigest(info.get("digest"));
            blobs.add((Blob)blob);
        }
        return blobs;
    }

    @Override
    public int getStorageSizeMB() {
        return (int)this.getStorageSize() / 0x100000;
    }

    @Override
    public void doGC() {
        log.debug((Object)String.format("Performing GC for TransientStore %s", this.config.getName()));
        long newSize = 0L;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(this.cacheDir.getAbsolutePath(), new String[0]));){
            for (Path entry : stream) {
                String key = this.getKeyCachingDirName(entry.getFileName().toString());
                try {
                    if (this.exists(key)) {
                        newSize += this.getFilePathSize(entry);
                        continue;
                    }
                    FileUtils.deleteDirectory((File)entry.toFile());
                }
                catch (IOException e) {
                    log.error((Object)"Error while performing GC", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while performing GC", (Throwable)e);
        }
        this.setStorageSize(newSize);
    }

    protected String getKeyCachingDirName(String dir) {
        String key = dir.replaceAll("_", "/");
        return new String(Base64.decodeBase64((String)key));
    }

    protected long getFilePathSize(Path entry) {
        long size = 0L;
        for (File file : entry.toFile().listFiles()) {
            size += file.length();
        }
        return size;
    }

    @Override
    public void removeAll() {
        log.debug((Object)("Removing all entries from TransientStore " + this.config.getName()));
        this.removeAllEntries();
        this.doGC();
    }
}

