/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.util.concurrent.Callable;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class DBSRepositoryService
extends DefaultComponent {
    protected DBSRepositoryDescriptorRegistry registry = new DBSRepositoryDescriptorRegistry();

    public void activate(ComponentContext context) {
        this.registry.clear();
    }

    public void deactivate(ComponentContext context) {
        this.registry.clear();
    }

    public void addContribution(DBSRepositoryDescriptor descriptor, Class<? extends DBSRepositoryFactory> factoryClass) {
        this.registry.addContribution(descriptor);
        this.updateRegistration(descriptor.name, factoryClass);
    }

    public void removeContribution(DBSRepositoryDescriptor descriptor, Class<? extends DBSRepositoryFactory> factoryClass) {
        this.registry.removeContribution(descriptor);
        this.updateRegistration(descriptor.name, factoryClass);
    }

    protected void updateRegistration(String repositoryName, Class<? extends DBSRepositoryFactory> factoryClass) {
        RepositoryFactory repositoryFactory;
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        DBSRepositoryDescriptor descriptor = this.registry.getRepositoryDescriptor(repositoryName);
        if (descriptor == null) {
            repositoryManager.removeRepository(repositoryName);
            return;
        }
        try {
            repositoryFactory = factoryClass.getConstructor(String.class).newInstance(repositoryName);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
        Repository repository = new Repository(repositoryName, descriptor.label, descriptor.isDefault(), (Callable)repositoryFactory);
        repositoryManager.addRepository(repository);
    }

    public DBSRepositoryDescriptor getRepositoryDescriptor(String name) {
        return this.registry.getRepositoryDescriptor(name);
    }

    protected static class DBSRepositoryDescriptorRegistry
    extends SimpleContributionRegistry<DBSRepositoryDescriptor> {
        protected DBSRepositoryDescriptorRegistry() {
        }

        public String getContributionId(DBSRepositoryDescriptor contrib) {
            return contrib.name;
        }

        public DBSRepositoryDescriptor clone(DBSRepositoryDescriptor orig) {
            return orig.clone();
        }

        public void merge(DBSRepositoryDescriptor src, DBSRepositoryDescriptor dst) {
            dst.merge(src);
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public void clear() {
            this.currentContribs.clear();
        }

        public DBSRepositoryDescriptor getRepositoryDescriptor(String id) {
            return (DBSRepositoryDescriptor)this.getCurrentContribution(id);
        }
    }
}

