/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.primitives;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.schema.types.PrimitiveType;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.EnumConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.NotNullConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.NumericIntervalConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.PatternConstraint;

public final class IntegerType
extends PrimitiveType {
    private static final long serialVersionUID = 1L;
    public static final String ID = "integer";
    public static final IntegerType INSTANCE = new IntegerType();

    private IntegerType() {
        super(ID);
    }

    @Override
    public boolean validate(Object object) {
        return object instanceof Number;
    }

    @Override
    public Object convert(Object value) {
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.valueOf((String)value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Object decode(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public String encode(Object object) {
        if (object instanceof Integer) {
            return object.toString();
        }
        if (object instanceof Number) {
            return object.toString();
        }
        return object != null ? (String)object : "";
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public boolean support(Class<? extends Constraint> constraint) {
        if (NotNullConstraint.class.equals(constraint)) {
            return true;
        }
        if (EnumConstraint.class.equals(constraint)) {
            return true;
        }
        if (PatternConstraint.class.equals(constraint)) {
            return true;
        }
        return NumericIntervalConstraint.class.equals(constraint);
    }
}

