/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.user.invite.UserRegistrationConfiguration;

@Operation(id="User.Invite", category="Users & Groups", label="Invite a user", description="Stores a registration request and returns its ID.")
public class UserInvite {
    public static final String ID = "User.Invite";
    @Context
    protected UserManager userManager;
    @Context
    protected UserInvitationService invitationService;
    @Param(name="validationMethod", required=false)
    protected UserInvitationService.ValidationMethod validationMethod = UserInvitationService.ValidationMethod.EMAIL;
    @Param(name="autoAccept", required=false)
    protected boolean autoAccept = true;
    @Param(name="info", required=false)
    protected Map<String, Serializable> info = new HashMap<String, Serializable>();
    @Param(name="comment", required=false)
    protected String comment;

    @OperationMethod
    public String run(NuxeoPrincipal user) {
        DocumentModel invitation = this.invitationService.getUserRegistrationModel(null);
        UserRegistrationConfiguration config = this.invitationService.getConfiguration();
        invitation.setPropertyValue(config.getUserInfoUsernameField(), (Serializable)((Object)user.getName()));
        invitation.setPropertyValue(config.getUserInfoFirstnameField(), (Serializable)((Object)user.getFirstName()));
        invitation.setPropertyValue(config.getUserInfoLastnameField(), (Serializable)((Object)user.getLastName()));
        invitation.setPropertyValue(config.getUserInfoEmailField(), (Serializable)((Object)user.getEmail()));
        invitation.setPropertyValue(config.getUserInfoGroupsField(), (Serializable)user.getGroups().toArray());
        invitation.setPropertyValue(config.getUserInfoTenantIdField(), (Serializable)((Object)user.getTenantId()));
        invitation.setPropertyValue(config.getUserInfoCompanyField(), (Serializable)((Object)user.getCompany()));
        invitation.setPropertyValue("registration:comment", (Serializable)((Object)this.comment));
        return this.invitationService.submitRegistrationRequest(invitation, this.info, this.validationMethod, this.autoAccept);
    }
}

