/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.features;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.platform.usermanager.UserManager;

public class PrincipalHelper {
    protected UserManager userManager;
    protected PermissionProvider permissionProvider;

    public PrincipalHelper(UserManager userManager, PermissionProvider permissionProvider) {
        this.userManager = userManager;
        this.permissionProvider = permissionProvider;
    }

    public Set<String> getEmailsForPermission(DocumentModel input, String permission, boolean ignoreGroups) {
        return this.collectObjectsMatchingPermission(input, permission, ignoreGroups, true, new EmailCollector(this.userManager.getUserSchemaName(), this.userManager.getUserEmailField()));
    }

    public Set<String> getUserAndGroupIdsForPermission(DocumentModel input, String permission, boolean ignoreGroups, boolean resolveGroups, boolean prefixIds) {
        return this.collectObjectsMatchingPermission(input, permission, ignoreGroups, resolveGroups, new IdCollector(prefixIds));
    }

    public Set<NuxeoPrincipal> getPrincipalsForPermission(DocumentModel input, String permission, boolean ignoreGroups, boolean resolveGroups) {
        return this.collectObjectsMatchingPermission(input, permission, ignoreGroups, resolveGroups, new PrincipalCollector());
    }

    public Set<String> getEmailsFromGroup(String groupId, boolean resolveGroups) {
        EmailCollector collector = new EmailCollector(this.userManager.getUserSchemaName(), this.userManager.getUserEmailField());
        this.collectObjectsFromGroup(groupId, resolveGroups, collector);
        return collector.getResult();
    }

    public Set<NuxeoPrincipal> getPrincipalsFromGroup(String groupId, boolean resolveGroups) {
        PrincipalCollector collector = new PrincipalCollector();
        this.collectObjectsFromGroup(groupId, resolveGroups, collector);
        return collector.getResult();
    }

    public Set<String> getUserNamesFromGroup(String groupId, boolean resolveGroups, boolean prefixIds) {
        IdCollector collector = new IdCollector(prefixIds);
        this.collectObjectsFromGroup(groupId, resolveGroups, collector);
        return collector.getResult();
    }

    public void collectObjectsFromGroup(String groupId, boolean resolveGroups, Collector<?> collector) {
        NuxeoGroup group = this.userManager.getGroup(groupId);
        if (group == null) {
            this.userManager.getPrincipal(groupId);
        } else {
            for (String u : group.getMemberUsers()) {
                NuxeoPrincipal principal = this.userManager.getPrincipal(u);
                if (principal == null) continue;
                collector.collect(principal);
            }
            if (resolveGroups) {
                for (String g : group.getMemberGroups()) {
                    this.collectObjectsFromGroup(g, resolveGroups, collector);
                }
            }
        }
    }

    public HashSet<?> collectObjectsMatchingPermission(DocumentModel input, String permission, boolean ignoreGroups, boolean resolveGroups, Collector<?> collector) {
        String[] perms = this.getPermissionsToCheck(permission);
        ACP acp = input.getACP();
        for (ACL acl : acp.getACLs()) {
            for (ACE ace : acl.getACEs()) {
                if (!ace.isGranted() || !this.permissionMatch(perms, ace.getPermission())) continue;
                NuxeoGroup group = this.userManager.getGroup(ace.getUsername());
                if (group == null) {
                    collector.collect(this.userManager.getPrincipal(ace.getUsername()));
                    continue;
                }
                if (ignoreGroups) continue;
                if (resolveGroups) {
                    this.resolveGroups(group, collector);
                    continue;
                }
                collector.collect(group);
            }
        }
        return collector.getResult();
    }

    public void resolveGroups(NuxeoGroup group, Collector<?> collector) {
        if (group != null) {
            for (String memberUser : group.getMemberUsers()) {
                collector.collect(this.userManager.getPrincipal(memberUser));
            }
            for (String subGroup : group.getMemberGroups()) {
                this.resolveGroups(this.userManager.getGroup(subGroup), collector);
            }
        }
    }

    public String[] getPermissionsToCheck(String permission) {
        String[] groups = this.permissionProvider.getPermissionGroups(permission);
        if (groups == null) {
            return new String[]{permission, "Everything"};
        }
        String[] perms = new String[groups.length + 2];
        perms[0] = permission;
        System.arraycopy(groups, 0, perms, 1, groups.length);
        perms[groups.length + 1] = "Everything";
        return perms;
    }

    public boolean permissionMatch(String[] perms, String perm) {
        for (String p : perms) {
            if (!p.equals(perm)) continue;
            return true;
        }
        return false;
    }

    static class IdCollector
    implements Collector<String> {
        protected final boolean prefixIds;
        protected HashSet<String> result = new HashSet();

        IdCollector(boolean prefixIds) {
            this.prefixIds = prefixIds;
        }

        @Override
        public void collect(NuxeoPrincipal principal) {
            String name;
            if (principal != null && (name = principal.getName()) != null) {
                if (this.prefixIds) {
                    this.result.add("user:" + name);
                } else {
                    this.result.add(name);
                }
            }
        }

        @Override
        public void collect(NuxeoGroup group) {
            String name;
            if (group != null && (name = group.getName()) != null) {
                if (this.prefixIds) {
                    this.result.add("group:" + name);
                } else {
                    this.result.add(name);
                }
            }
        }

        @Override
        public HashSet<String> getResult() {
            return this.result;
        }
    }

    static class PrincipalCollector
    implements Collector<NuxeoPrincipal> {
        protected HashSet<NuxeoPrincipal> result = new HashSet();

        PrincipalCollector() {
        }

        @Override
        public void collect(NuxeoPrincipal principal) {
            if (principal == null) {
                return;
            }
            this.result.add(principal);
        }

        @Override
        public void collect(NuxeoGroup group) {
        }

        @Override
        public HashSet<NuxeoPrincipal> getResult() {
            return this.result;
        }
    }

    public static class EmailCollector
    implements Collector<String> {
        protected final String userSchemaName;
        protected final String userEmailFieldName;
        protected HashSet<String> result = new HashSet();

        EmailCollector(String userSchemaName, String userEmailFieldName) {
            this.userSchemaName = userSchemaName;
            this.userEmailFieldName = userEmailFieldName;
        }

        @Override
        public void collect(NuxeoPrincipal principal) {
            if (principal == null) {
                return;
            }
            DocumentModel userEntry = principal.getModel();
            String email = (String)userEntry.getProperty(this.userSchemaName, this.userEmailFieldName);
            if (!StringUtils.isEmpty((String)email)) {
                this.result.add(email);
            }
        }

        @Override
        public void collect(NuxeoGroup group) {
        }

        @Override
        public HashSet<String> getResult() {
            return this.result;
        }
    }

    static interface Collector<T> {
        public void collect(NuxeoPrincipal var1);

        public void collect(NuxeoGroup var1);

        public HashSet<T> getResult();
    }
}

