/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.nuxeo.common.utils.JDBCUtils;
import org.nuxeo.runtime.api.Framework;

public class DataSourceFromUrl
implements DataSource {
    private final String url;
    private final String user;
    private final String password;

    public DataSourceFromUrl(String url, String user, String password) {
        this.url = Framework.expandVars((String)url);
        this.user = Framework.expandVars((String)user);
        this.password = Framework.expandVars((String)password);
    }

    public DataSourceFromUrl(String url, String user, String password, String driver) {
        this(url, user, password);
        if (driver != null) {
            driver = Framework.expandVars((String)driver);
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Driver class not found: " + driver, e);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection con = JDBCUtils.getConnection((String)this.url, (String)this.user, (String)this.password);
        con.setAutoCommit(true);
        return con;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

