/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.invite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.runtime.api.Framework;

public class RegistrationRules {
    public static final String FACET_REGISTRATION_CONFIGURATION = "RegistrationConfiguration";
    public static final String SCHEMA_REGISTRATION_RULES = "registrationconfiguration";
    public static final String FIELD_ALLOW_USER_CREATION = "registrationconfiguration:allowUserCreation";
    public static final String FIELD_ALLOW_DIRECT_VALIDATION = "registrationconfiguration:allowDirectValidationForExistingUser";
    public static final String FIELD_FORCE_RIGHT = "registrationconfiguration:forceRightAssignment";
    public static final String FIELD_CONFIGURATION_NAME = "registrationconfiguration:name";
    public static final String FIELD_DISPLAY_LOCAL_TAB = "registrationconfiguration:displayLocalRegistrationTab";
    protected DocumentModel requestContainer;
    private static final Log log = LogFactory.getLog(RegistrationRules.class);

    public RegistrationRules(DocumentModel requestContainer) {
        this.requestContainer = requestContainer;
    }

    public boolean allowUserCreation() {
        try {
            return (Boolean)this.requestContainer.getPropertyValue(FIELD_ALLOW_USER_CREATION);
        }
        catch (PropertyException e) {
            log.warn((Object)("Unable to fetch AllowUserCreation flag using default value: " + e.getMessage()));
            return true;
        }
    }

    public boolean allowDirectValidationForExistingUser() {
        try {
            return (Boolean)this.requestContainer.getPropertyValue(FIELD_ALLOW_DIRECT_VALIDATION);
        }
        catch (PropertyException e) {
            log.warn((Object)("Unable to fetch AllowDirectValidation flag using default value: " + e.getMessage()));
            return false;
        }
    }

    public boolean isForcingRight() {
        try {
            return (Boolean)this.requestContainer.getPropertyValue(FIELD_FORCE_RIGHT);
        }
        catch (PropertyException e) {
            log.warn((Object)("Unable to fetch ForceRight flag using default value: " + e.getMessage()));
            return false;
        }
    }

    public boolean isDisplayLocalTab() {
        try {
            return (Boolean)this.requestContainer.getPropertyValue(FIELD_DISPLAY_LOCAL_TAB);
        }
        catch (PropertyException e) {
            log.warn((Object)("Unable to fetch display local tab flag using default value: " + e.getMessage()));
            return true;
        }
    }

    public boolean allowDirectValidationForNonExistingUser() {
        return Framework.isBooleanPropertyTrue((String)"nuxeo.user.registration.force.validation.non.existing");
    }
}

