/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.converters.LayoutConversionContext;
import org.nuxeo.ecm.platform.forms.layout.api.converters.LayoutDefinitionConverter;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.ecm.platform.forms.layout.io.JSONLayoutExporter;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.webengine.model.view.TemplateView;
import org.nuxeo.runtime.api.Framework;

public class LayoutResource {
    public static final String DEFAULT_DOCUMENT_LAYOUT_MODE = "edit";
    public static final String DEFAULT_CONVERSION_CATEGORY = "standalone";
    public static final String DEFAULT_LANGUAGE = "en";
    protected final String category;
    protected LayoutStore service;
    protected List<String> registeredLayoutNames;

    public LayoutResource(String category) {
        this.category = category;
        this.service = (LayoutStore)Framework.getService(LayoutStore.class);
        this.registeredLayoutNames = this.service.getLayoutDefinitionNames(category);
        Collections.sort(this.registeredLayoutNames);
    }

    protected TemplateView getTemplate(String name, UriInfo uriInfo) {
        String baseURL = uriInfo.getAbsolutePath().toString();
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        return new TemplateView((Object)this, name).arg("baseURL", (Object)baseURL).arg("layoutNames", this.registeredLayoutNames);
    }

    @GET
    public Object doGet(@QueryParam(value="layoutName") String layoutName, @Context UriInfo uriInfo) {
        TemplateView tpl = this.getTemplate("layouts.ftl", uriInfo);
        if (layoutName != null) {
            LayoutDefinition layoutDef = this.service.getLayoutDefinition(this.category, layoutName);
            tpl.arg("layoutDefinition", (Object)layoutDef);
        }
        return tpl;
    }

    @GET
    @Path(value="json")
    public String getAsJson(@QueryParam(value="layoutName") String layoutName, @QueryParam(value="lang") String lang, @QueryParam(value="convertCat") String conversionCategory) {
        if (layoutName != null) {
            LayoutDefinition layoutDef;
            if (StringUtils.isBlank((String)lang)) {
                lang = DEFAULT_LANGUAGE;
            }
            if (StringUtils.isBlank((String)conversionCategory)) {
                conversionCategory = DEFAULT_CONVERSION_CATEGORY;
            }
            if ((layoutDef = this.service.getLayoutDefinition(this.category, layoutName)) != null) {
                LayoutConversionContext ctx = new LayoutConversionContext(lang, null);
                List layoutConverters = this.service.getLayoutConverters(conversionCategory);
                for (LayoutDefinitionConverter conv : layoutConverters) {
                    layoutDef = conv.getLayoutDefinition(layoutDef, ctx);
                }
                if (layoutDef != null) {
                    List widgetConverters = this.service.getWidgetConverters(conversionCategory);
                    JSONObject json = JSONLayoutExporter.exportToJson((String)this.category, (LayoutDefinition)layoutDef, (LayoutConversionContext)ctx, (List)widgetConverters);
                    return json.toString(2);
                }
            }
        }
        return "No layout found";
    }

    @GET
    @Path(value="docType/{docType}")
    public String getLayoutsForTypeAsJson(@PathParam(value="docType") String docType, @QueryParam(value="mode") String mode, @QueryParam(value="lang") String lang, @QueryParam(value="convertCat") String conversionCategory) {
        if (StringUtils.isBlank((String)mode)) {
            mode = DEFAULT_DOCUMENT_LAYOUT_MODE;
        }
        if (StringUtils.isBlank((String)lang)) {
            lang = DEFAULT_LANGUAGE;
        }
        if (StringUtils.isBlank((String)conversionCategory)) {
            conversionCategory = DEFAULT_CONVERSION_CATEGORY;
        }
        TypeManager tm = (TypeManager)Framework.getLocalService(TypeManager.class);
        String[] layoutNames = tm.getType(docType).getLayouts(mode);
        JSONArray jsonLayouts = new JSONArray();
        for (String layoutName : layoutNames) {
            LayoutDefinition layoutDef = this.service.getLayoutDefinition(this.category, layoutName);
            LayoutConversionContext ctx = new LayoutConversionContext(lang, null);
            List layoutConverters = this.service.getLayoutConverters(conversionCategory);
            for (LayoutDefinitionConverter conv : layoutConverters) {
                layoutDef = conv.getLayoutDefinition(layoutDef, ctx);
            }
            if (layoutDef == null) continue;
            List widgetConverters = this.service.getWidgetConverters(conversionCategory);
            JSONObject jsonLayout = JSONLayoutExporter.exportToJson((String)this.category, (LayoutDefinition)layoutDef, (LayoutConversionContext)ctx, (List)widgetConverters);
            jsonLayouts.add((Object)jsonLayout);
        }
        return jsonLayouts.toString(2);
    }
}

