/*
 * jQuery UI Resizable 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/resizable/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
(function(C,D){function B(E){return parseInt(E,10)||0
}function A(E){return !isNaN(parseInt(E,10))
}C.widget("ui.resizable",C.ui.mouse,{version:"1.10.3",widgetEventPrefix:"resize",options:{alsoResize:false,animate:false,animateDuration:"slow",animateEasing:"swing",aspectRatio:false,autoHide:false,containment:false,ghost:false,grid:false,handles:"e,s,se",helper:false,maxHeight:null,maxWidth:null,minHeight:10,minWidth:10,zIndex:90,resize:null,start:null,stop:null},_create:function(){var K,F,I,G,E,H=this,J=this.options;
this.element.addClass("ui-resizable");
C.extend(this,{_aspectRatio:!!(J.aspectRatio),aspectRatio:J.aspectRatio,originalElement:this.element,_proportionallyResizeElements:[],_helper:J.helper||J.ghost||J.animate?J.helper||"ui-resizable-helper":null});
if(this.element[0].nodeName.match(/canvas|textarea|input|select|button|img/i)){this.element.wrap(C("<div class='ui-wrapper' style='overflow: hidden;'></div>").css({position:this.element.css("position"),width:this.element.outerWidth(),height:this.element.outerHeight(),top:this.element.css("top"),left:this.element.css("left")}));
this.element=this.element.parent().data("ui-resizable",this.element.data("ui-resizable"));
this.elementIsWrapper=true;
this.element.css({marginLeft:this.originalElement.css("marginLeft"),marginTop:this.originalElement.css("marginTop"),marginRight:this.originalElement.css("marginRight"),marginBottom:this.originalElement.css("marginBottom")});
this.originalElement.css({marginLeft:0,marginTop:0,marginRight:0,marginBottom:0});
this.originalResizeStyle=this.originalElement.css("resize");
this.originalElement.css("resize","none");
this._proportionallyResizeElements.push(this.originalElement.css({position:"static",zoom:1,display:"block"}));
this.originalElement.css({margin:this.originalElement.css("margin")});
this._proportionallyResize()
}this.handles=J.handles||(!C(".ui-resizable-handle",this.element).length?"e,s,se":{n:".ui-resizable-n",e:".ui-resizable-e",s:".ui-resizable-s",w:".ui-resizable-w",se:".ui-resizable-se",sw:".ui-resizable-sw",ne:".ui-resizable-ne",nw:".ui-resizable-nw"});
if(this.handles.constructor===String){if(this.handles==="all"){this.handles="n,e,s,w,se,sw,ne,nw"
}K=this.handles.split(",");
this.handles={};
for(F=0;
F<K.length;
F++){I=C.trim(K[F]);
E="ui-resizable-"+I;
G=C("<div class='ui-resizable-handle "+E+"'></div>");
G.css({zIndex:J.zIndex});
if("se"===I){G.addClass("ui-icon ui-icon-gripsmall-diagonal-se")
}this.handles[I]=".ui-resizable-"+I;
this.element.append(G)
}}this._renderAxis=function(P){var M,N,L,O;
P=P||this.element;
for(M in this.handles){if(this.handles[M].constructor===String){this.handles[M]=C(this.handles[M],this.element).show()
}if(this.elementIsWrapper&&this.originalElement[0].nodeName.match(/textarea|input|select|button/i)){N=C(this.handles[M],this.element);
O=/sw|ne|nw|se|n|s/.test(M)?N.outerHeight():N.outerWidth();
L=["padding",/ne|nw|n/.test(M)?"Top":/se|sw|s/.test(M)?"Bottom":/^e$/.test(M)?"Right":"Left"].join("");
P.css(L,O);
this._proportionallyResize()
}if(!C(this.handles[M]).length){continue
}}};
this._renderAxis(this.element);
this._handles=C(".ui-resizable-handle",this.element).disableSelection();
this._handles.mouseover(function(){if(!H.resizing){if(this.className){G=this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i)
}H.axis=G&&G[1]?G[1]:"se"
}});
if(J.autoHide){this._handles.hide();
C(this.element).addClass("ui-resizable-autohide").mouseenter(function(){if(J.disabled){return 
}C(this).removeClass("ui-resizable-autohide");
H._handles.show()
}).mouseleave(function(){if(J.disabled){return 
}if(!H.resizing){C(this).addClass("ui-resizable-autohide");
H._handles.hide()
}})
}this._mouseInit()
},_destroy:function(){this._mouseDestroy();
var F,E=function(G){C(G).removeClass("ui-resizable ui-resizable-disabled ui-resizable-resizing").removeData("resizable").removeData("ui-resizable").unbind(".resizable").find(".ui-resizable-handle").remove()
};
if(this.elementIsWrapper){E(this.element);
F=this.element;
this.originalElement.css({position:F.css("position"),width:F.outerWidth(),height:F.outerHeight(),top:F.css("top"),left:F.css("left")}).insertAfter(F);
F.remove()
}this.originalElement.css("resize",this.originalResizeStyle);
E(this.originalElement);
return this
},_mouseCapture:function(G){var F,H,E=false;
for(F in this.handles){H=C(this.handles[F])[0];
if(H===G.target||C.contains(H,G.target)){E=true
}}return !this.options.disabled&&E
},_mouseStart:function(G){var K,H,J,I=this.options,F=this.element.position(),E=this.element;
this.resizing=true;
if((/absolute/).test(E.css("position"))){E.css({position:"absolute",top:E.css("top"),left:E.css("left")})
}else{if(E.is(".ui-draggable")){E.css({position:"absolute",top:F.top,left:F.left})
}}this._renderProxy();
K=B(this.helper.css("left"));
H=B(this.helper.css("top"));
if(I.containment){K+=C(I.containment).scrollLeft()||0;
H+=C(I.containment).scrollTop()||0
}this.offset=this.helper.offset();
this.position={left:K,top:H};
this.size=this._helper?{width:E.outerWidth(),height:E.outerHeight()}:{width:E.width(),height:E.height()};
this.originalSize=this._helper?{width:E.outerWidth(),height:E.outerHeight()}:{width:E.width(),height:E.height()};
this.originalPosition={left:K,top:H};
this.sizeDiff={width:E.outerWidth()-E.width(),height:E.outerHeight()-E.height()};
this.originalMousePosition={left:G.pageX,top:G.pageY};
this.aspectRatio=(typeof I.aspectRatio==="number")?I.aspectRatio:((this.originalSize.width/this.originalSize.height)||1);
J=C(".ui-resizable-"+this.axis).css("cursor");
C("body").css("cursor",J==="auto"?this.axis+"-resize":J);
E.addClass("ui-resizable-resizing");
this._propagate("start",G);
return true
},_mouseDrag:function(E){var K,G=this.helper,L={},I=this.originalMousePosition,M=this.axis,O=this.position.top,F=this.position.left,N=this.size.width,J=this.size.height,Q=(E.pageX-I.left)||0,P=(E.pageY-I.top)||0,H=this._change[M];
if(!H){return false
}K=H.apply(this,[E,Q,P]);
this._updateVirtualBoundaries(E.shiftKey);
if(this._aspectRatio||E.shiftKey){K=this._updateRatio(K,E)
}K=this._respectSize(K,E);
this._updateCache(K);
this._propagate("resize",E);
if(this.position.top!==O){L.top=this.position.top+"px"
}if(this.position.left!==F){L.left=this.position.left+"px"
}if(this.size.width!==N){L.width=this.size.width+"px"
}if(this.size.height!==J){L.height=this.size.height+"px"
}G.css(L);
if(!this._helper&&this._proportionallyResizeElements.length){this._proportionallyResize()
}if(!C.isEmptyObject(L)){this._trigger("resize",E,this.ui())
}return false
},_mouseStop:function(H){this.resizing=false;
var G,E,F,K,N,J,M,I=this.options,L=this;
if(this._helper){G=this._proportionallyResizeElements;
E=G.length&&(/textarea/i).test(G[0].nodeName);
F=E&&C.ui.hasScroll(G[0],"left")?0:L.sizeDiff.height;
K=E?0:L.sizeDiff.width;
N={width:(L.helper.width()-K),height:(L.helper.height()-F)};
J=(parseInt(L.element.css("left"),10)+(L.position.left-L.originalPosition.left))||null;
M=(parseInt(L.element.css("top"),10)+(L.position.top-L.originalPosition.top))||null;
if(!I.animate){this.element.css(C.extend(N,{top:M,left:J}))
}L.helper.height(L.size.height);
L.helper.width(L.size.width);
if(this._helper&&!I.animate){this._proportionallyResize()
}}C("body").css("cursor","auto");
this.element.removeClass("ui-resizable-resizing");
this._propagate("stop",H);
if(this._helper){this.helper.remove()
}return false
},_updateVirtualBoundaries:function(G){var I,H,F,K,E,J=this.options;
E={minWidth:A(J.minWidth)?J.minWidth:0,maxWidth:A(J.maxWidth)?J.maxWidth:Infinity,minHeight:A(J.minHeight)?J.minHeight:0,maxHeight:A(J.maxHeight)?J.maxHeight:Infinity};
if(this._aspectRatio||G){I=E.minHeight*this.aspectRatio;
F=E.minWidth/this.aspectRatio;
H=E.maxHeight*this.aspectRatio;
K=E.maxWidth/this.aspectRatio;
if(I>E.minWidth){E.minWidth=I
}if(F>E.minHeight){E.minHeight=F
}if(H<E.maxWidth){E.maxWidth=H
}if(K<E.maxHeight){E.maxHeight=K
}}this._vBoundaries=E
},_updateCache:function(E){this.offset=this.helper.offset();
if(A(E.left)){this.position.left=E.left
}if(A(E.top)){this.position.top=E.top
}if(A(E.height)){this.size.height=E.height
}if(A(E.width)){this.size.width=E.width
}},_updateRatio:function(G){var H=this.position,F=this.size,E=this.axis;
if(A(G.height)){G.width=(G.height*this.aspectRatio)
}else{if(A(G.width)){G.height=(G.width/this.aspectRatio)
}}if(E==="sw"){G.left=H.left+(F.width-G.width);
G.top=null
}if(E==="nw"){G.top=H.top+(F.height-G.height);
G.left=H.left+(F.width-G.width)
}return G
},_respectSize:function(J){var G=this._vBoundaries,M=this.axis,O=A(J.width)&&G.maxWidth&&(G.maxWidth<J.width),K=A(J.height)&&G.maxHeight&&(G.maxHeight<J.height),H=A(J.width)&&G.minWidth&&(G.minWidth>J.width),N=A(J.height)&&G.minHeight&&(G.minHeight>J.height),F=this.originalPosition.left+this.originalSize.width,L=this.position.top+this.size.height,I=/sw|nw|w/.test(M),E=/nw|ne|n/.test(M);
if(H){J.width=G.minWidth
}if(N){J.height=G.minHeight
}if(O){J.width=G.maxWidth
}if(K){J.height=G.maxHeight
}if(H&&I){J.left=F-G.minWidth
}if(O&&I){J.left=F-G.maxWidth
}if(N&&E){J.top=L-G.minHeight
}if(K&&E){J.top=L-G.maxHeight
}if(!J.width&&!J.height&&!J.left&&J.top){J.top=null
}else{if(!J.width&&!J.height&&!J.top&&J.left){J.left=null
}}return J
},_proportionallyResize:function(){if(!this._proportionallyResizeElements.length){return 
}var H,F,J,E,I,G=this.helper||this.element;
for(H=0;
H<this._proportionallyResizeElements.length;
H++){I=this._proportionallyResizeElements[H];
if(!this.borderDif){this.borderDif=[];
J=[I.css("borderTopWidth"),I.css("borderRightWidth"),I.css("borderBottomWidth"),I.css("borderLeftWidth")];
E=[I.css("paddingTop"),I.css("paddingRight"),I.css("paddingBottom"),I.css("paddingLeft")];
for(F=0;
F<J.length;
F++){this.borderDif[F]=(parseInt(J[F],10)||0)+(parseInt(E[F],10)||0)
}}I.css({height:(G.height()-this.borderDif[0]-this.borderDif[2])||0,width:(G.width()-this.borderDif[1]-this.borderDif[3])||0})
}},_renderProxy:function(){var E=this.element,F=this.options;
this.elementOffset=E.offset();
if(this._helper){this.helper=this.helper||C("<div style='overflow:hidden;'></div>");
this.helper.addClass(this._helper).css({width:this.element.outerWidth()-1,height:this.element.outerHeight()-1,position:"absolute",left:this.elementOffset.left+"px",top:this.elementOffset.top+"px",zIndex:++F.zIndex});
this.helper.appendTo("body").disableSelection()
}else{this.helper=this.element
}},_change:{e:function(F,E){return{width:this.originalSize.width+E}
},w:function(G,E){var F=this.originalSize,H=this.originalPosition;
return{left:H.left+E,width:F.width-E}
},n:function(H,F,E){var G=this.originalSize,I=this.originalPosition;
return{top:I.top+E,height:G.height-E}
},s:function(G,F,E){return{height:this.originalSize.height+E}
},se:function(G,F,E){return C.extend(this._change.s.apply(this,arguments),this._change.e.apply(this,[G,F,E]))
},sw:function(G,F,E){return C.extend(this._change.s.apply(this,arguments),this._change.w.apply(this,[G,F,E]))
},ne:function(G,F,E){return C.extend(this._change.n.apply(this,arguments),this._change.e.apply(this,[G,F,E]))
},nw:function(G,F,E){return C.extend(this._change.n.apply(this,arguments),this._change.w.apply(this,[G,F,E]))
}},_propagate:function(F,E){C.ui.plugin.call(this,F,[E,this.ui()]);
(F!=="resize"&&this._trigger(F,E,this.ui()))
},plugins:{},ui:function(){return{originalElement:this.originalElement,element:this.element,helper:this.helper,position:this.position,size:this.size,originalSize:this.originalSize,originalPosition:this.originalPosition}
}});
C.ui.plugin.add("resizable","animate",{stop:function(H){var M=C(this).data("ui-resizable"),J=M.options,G=M._proportionallyResizeElements,E=G.length&&(/textarea/i).test(G[0].nodeName),F=E&&C.ui.hasScroll(G[0],"left")?0:M.sizeDiff.height,L=E?0:M.sizeDiff.width,I={width:(M.size.width-L),height:(M.size.height-F)},K=(parseInt(M.element.css("left"),10)+(M.position.left-M.originalPosition.left))||null,N=(parseInt(M.element.css("top"),10)+(M.position.top-M.originalPosition.top))||null;
M.element.animate(C.extend(I,N&&K?{top:N,left:K}:{}),{duration:J.animateDuration,easing:J.animateEasing,step:function(){var O={width:parseInt(M.element.css("width"),10),height:parseInt(M.element.css("height"),10),top:parseInt(M.element.css("top"),10),left:parseInt(M.element.css("left"),10)};
if(G&&G.length){C(G[0]).css({width:O.width,height:O.height})
}M._updateCache(O);
M._propagate("resize",H)
}})
}});
C.ui.plugin.add("resizable","containment",{start:function(){var M,G,O,E,L,H,P,N=C(this).data("ui-resizable"),K=N.options,J=N.element,F=K.containment,I=(F instanceof C)?F.get(0):(/parent/.test(F))?J.parent().get(0):F;
if(!I){return 
}N.containerElement=C(I);
if(/document/.test(F)||F===document){N.containerOffset={left:0,top:0};
N.containerPosition={left:0,top:0};
N.parentData={element:C(document),left:0,top:0,width:C(document).width(),height:C(document).height()||document.body.parentNode.scrollHeight}
}else{M=C(I);
G=[];
C(["Top","Right","Left","Bottom"]).each(function(R,Q){G[R]=B(M.css("padding"+Q))
});
N.containerOffset=M.offset();
N.containerPosition=M.position();
N.containerSize={height:(M.innerHeight()-G[3]),width:(M.innerWidth()-G[1])};
O=N.containerOffset;
E=N.containerSize.height;
L=N.containerSize.width;
H=(C.ui.hasScroll(I,"left")?I.scrollWidth:L);
P=(C.ui.hasScroll(I)?I.scrollHeight:E);
N.parentData={element:I,left:O.left,top:O.top,width:H,height:P}
}},resize:function(F){var K,P,J,I,L=C(this).data("ui-resizable"),H=L.options,N=L.containerOffset,M=L.position,O=L._aspectRatio||F.shiftKey,E={top:0,left:0},G=L.containerElement;
if(G[0]!==document&&(/static/).test(G.css("position"))){E=N
}if(M.left<(L._helper?N.left:0)){L.size.width=L.size.width+(L._helper?(L.position.left-N.left):(L.position.left-E.left));
if(O){L.size.height=L.size.width/L.aspectRatio
}L.position.left=H.helper?N.left:0
}if(M.top<(L._helper?N.top:0)){L.size.height=L.size.height+(L._helper?(L.position.top-N.top):L.position.top);
if(O){L.size.width=L.size.height*L.aspectRatio
}L.position.top=L._helper?N.top:0
}L.offset.left=L.parentData.left+L.position.left;
L.offset.top=L.parentData.top+L.position.top;
K=Math.abs((L._helper?L.offset.left-E.left:(L.offset.left-E.left))+L.sizeDiff.width);
P=Math.abs((L._helper?L.offset.top-E.top:(L.offset.top-N.top))+L.sizeDiff.height);
J=L.containerElement.get(0)===L.element.parent().get(0);
I=/relative|absolute/.test(L.containerElement.css("position"));
if(J&&I){K-=L.parentData.left
}if(K+L.size.width>=L.parentData.width){L.size.width=L.parentData.width-K;
if(O){L.size.height=L.size.width/L.aspectRatio
}}if(P+L.size.height>=L.parentData.height){L.size.height=L.parentData.height-P;
if(O){L.size.width=L.size.height*L.aspectRatio
}}},stop:function(){var J=C(this).data("ui-resizable"),F=J.options,K=J.containerOffset,E=J.containerPosition,G=J.containerElement,H=C(J.helper),M=H.offset(),L=H.outerWidth()-J.sizeDiff.width,I=H.outerHeight()-J.sizeDiff.height;
if(J._helper&&!F.animate&&(/relative/).test(G.css("position"))){C(this).css({left:M.left-E.left-K.left,width:L,height:I})
}if(J._helper&&!F.animate&&(/static/).test(G.css("position"))){C(this).css({left:M.left-E.left-K.left,width:L,height:I})
}}});
C.ui.plugin.add("resizable","alsoResize",{start:function(){var E=C(this).data("ui-resizable"),G=E.options,F=function(H){C(H).each(function(){var I=C(this);
I.data("ui-resizable-alsoresize",{width:parseInt(I.width(),10),height:parseInt(I.height(),10),left:parseInt(I.css("left"),10),top:parseInt(I.css("top"),10)})
})
};
if(typeof (G.alsoResize)==="object"&&!G.alsoResize.parentNode){if(G.alsoResize.length){G.alsoResize=G.alsoResize[0];
F(G.alsoResize)
}else{C.each(G.alsoResize,function(H){F(H)
})
}}else{F(G.alsoResize)
}},resize:function(G,I){var F=C(this).data("ui-resizable"),J=F.options,H=F.originalSize,L=F.originalPosition,K={height:(F.size.height-H.height)||0,width:(F.size.width-H.width)||0,top:(F.position.top-L.top)||0,left:(F.position.left-L.left)||0},E=function(M,N){C(M).each(function(){var Q=C(this),R=C(this).data("ui-resizable-alsoresize"),P={},O=N&&N.length?N:Q.parents(I.originalElement[0]).length?["width","height"]:["width","height","top","left"];
C.each(O,function(S,U){var T=(R[U]||0)+(K[U]||0);
if(T&&T>=0){P[U]=T||null
}});
Q.css(P)
})
};
if(typeof (J.alsoResize)==="object"&&!J.alsoResize.nodeType){C.each(J.alsoResize,function(M,N){E(M,N)
})
}else{E(J.alsoResize)
}},stop:function(){C(this).removeData("resizable-alsoresize")
}});
C.ui.plugin.add("resizable","ghost",{start:function(){var F=C(this).data("ui-resizable"),G=F.options,E=F.size;
F.ghost=F.originalElement.clone();
F.ghost.css({opacity:0.25,display:"block",position:"relative",height:E.height,width:E.width,margin:0,left:0,top:0}).addClass("ui-resizable-ghost").addClass(typeof G.ghost==="string"?G.ghost:"");
F.ghost.appendTo(F.helper)
},resize:function(){var E=C(this).data("ui-resizable");
if(E.ghost){E.ghost.css({position:"relative",height:E.size.height,width:E.size.width})
}},stop:function(){var E=C(this).data("ui-resizable");
if(E.ghost&&E.helper){E.helper.get(0).removeChild(E.ghost.get(0))
}}});
C.ui.plugin.add("resizable","grid",{resize:function(){var Q=C(this).data("ui-resizable"),I=Q.options,R=Q.size,K=Q.originalSize,N=Q.originalPosition,S=Q.axis,F=typeof I.grid==="number"?[I.grid,I.grid]:I.grid,O=(F[0]||1),M=(F[1]||1),H=Math.round((R.width-K.width)/O)*O,G=Math.round((R.height-K.height)/M)*M,L=K.width+H,E=K.height+G,J=I.maxWidth&&(I.maxWidth<L),T=I.maxHeight&&(I.maxHeight<E),P=I.minWidth&&(I.minWidth>L),U=I.minHeight&&(I.minHeight>E);
I.grid=F;
if(P){L=L+O
}if(U){E=E+M
}if(J){L=L-O
}if(T){E=E-M
}if(/^(se|s|e)$/.test(S)){Q.size.width=L;
Q.size.height=E
}else{if(/^(ne)$/.test(S)){Q.size.width=L;
Q.size.height=E;
Q.position.top=N.top-G
}else{if(/^(sw)$/.test(S)){Q.size.width=L;
Q.size.height=E;
Q.position.left=N.left-H
}else{Q.size.width=L;
Q.size.height=E;
Q.position.top=N.top-G;
Q.position.left=N.left-H
}}}}})
})(jQuery);