/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.events;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.management.events.CallStat;

public class EventStatsHolder {
    protected static boolean collectAsyncHandlersExecTime = false;
    protected static boolean collectSyncHandlersExecTime = false;
    protected static Map<String, CallStat> syncStats = new HashMap<String, CallStat>();
    protected static Map<String, CallStat> aSyncStats = new HashMap<String, CallStat>();

    private EventStatsHolder() {
    }

    public static boolean isCollectAsyncHandlersExecTime() {
        return collectAsyncHandlersExecTime;
    }

    public static void setCollectAsyncHandlersExecTime(boolean collectAsyncHandlersExecTime) {
        EventStatsHolder.collectAsyncHandlersExecTime = collectAsyncHandlersExecTime;
    }

    public static boolean isCollectSyncHandlersExecTime() {
        return collectSyncHandlersExecTime;
    }

    public static void setCollectSyncHandlersExecTime(boolean collectSyncHandlersExecTime) {
        EventStatsHolder.collectSyncHandlersExecTime = collectSyncHandlersExecTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logAsyncExec(EventListenerDescriptor desc, long delta) {
        if (!collectAsyncHandlersExecTime) {
            return;
        }
        String name = desc.getName();
        Map<String, CallStat> map = aSyncStats;
        synchronized (map) {
            CallStat stat = aSyncStats.get(name);
            if (stat == null) {
                String label = desc.asPostCommitListener().getClass().getSimpleName();
                label = desc.getIsAsync() ? label + "(async)" : label + "(sync)";
                stat = new CallStat(label);
                aSyncStats.put(name, stat);
            }
            stat.update(delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logSyncExec(EventListenerDescriptor desc, long delta) {
        if (!collectSyncHandlersExecTime) {
            return;
        }
        String name = desc.getName();
        Map<String, CallStat> map = syncStats;
        synchronized (map) {
            CallStat stat = syncStats.get(name);
            if (stat == null) {
                String label = desc.asEventListener().getClass().getSimpleName();
                stat = new CallStat(label);
                syncStats.put(name, stat);
            }
            stat.update(delta);
        }
    }

    public static String getAsyncHandlersExecTime() {
        return EventStatsHolder.getStringSummary(aSyncStats);
    }

    public static String getSyncHandlersExecTime() {
        return EventStatsHolder.getStringSummary(syncStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getStringSummary(Map<String, CallStat> stats) {
        StringBuffer sb = new StringBuffer();
        Map<String, CallStat> map = stats;
        synchronized (map) {
            long totalTime = 0L;
            for (String name : stats.keySet()) {
                totalTime += stats.get(name).getAccumulatedTime();
            }
            for (String name : stats.keySet()) {
                CallStat stat = stats.get(name);
                sb.append(name);
                sb.append(" - ");
                sb.append(stat.getLabel());
                sb.append(" - ");
                sb.append(stat.getCallCount());
                sb.append(" calls - ");
                sb.append(stat.getAccumulatedTime());
                sb.append("ms - ");
                String pcent = String.format("%.2f", 100.0 * (double)stat.getAccumulatedTime() / (double)totalTime);
                sb.append(pcent);
                sb.append("%\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetHandlersExecTime() {
        Map<String, CallStat> map = syncStats;
        synchronized (map) {
            syncStats = new HashMap<String, CallStat>();
        }
        map = aSyncStats;
        synchronized (map) {
            aSyncStats = new HashMap<String, CallStat>();
        }
    }
}

