/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.core.impl.ElementRunner;

public abstract class AbstractRunner
implements ElementRunner {
    protected List<DocumentRouteElement> getChildrenElement(CoreSession session, DocumentRouteElement element) {
        try {
            DocumentModelList children = session.getChildren(element.getDocument().getRef());
            ArrayList<DocumentRouteElement> elements = new ArrayList<DocumentRouteElement>();
            for (DocumentModel model : children) {
                elements.add((DocumentRouteElement)model.getAdapter(DocumentRouteElement.class));
            }
            return elements;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void undo(CoreSession session, DocumentRouteElement element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancel(CoreSession session, DocumentRouteElement element) {
        List<DocumentRouteElement> children = this.getChildrenElement(session, element);
        for (DocumentRouteElement child : children) {
            child.cancel(session);
        }
        element.setCanceled(session);
    }
}

