/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.runner;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingPersister;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;
import org.nuxeo.runtime.api.Framework;

public class CreateNewRouteInstanceUnrestricted
extends UnrestrictedSessionRunner {
    protected DocumentModel instance;
    protected DocumentRoute model;
    protected List<String> docIds;
    protected boolean startInstance;
    protected String initiator;
    protected DocumentRoutingPersister persister;

    public CreateNewRouteInstanceUnrestricted(CoreSession session, DocumentRoute model, List<String> docIds, boolean startInstance, DocumentRoutingPersister persister) {
        super(session);
        this.model = model;
        this.docIds = docIds;
        this.startInstance = startInstance;
        this.initiator = session.getPrincipal().getName();
        this.persister = persister;
    }

    public void run() throws ClientException {
        this.instance = this.persister.createDocumentRouteInstanceFromDocumentRouteModel(this.model.getDocument(), this.session);
        DocumentRoute routeInstance = (DocumentRoute)this.instance.getAdapter(DocumentRoute.class);
        routeInstance.setAttachedDocuments(this.docIds);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("initiator", (Serializable)((Object)this.initiator));
        this.fireEvent(this.session, (DocumentRouteElement)routeInstance, props, DocumentRoutingConstants.Events.beforeRouteReady.name());
        routeInstance.setReady(this.session);
        this.fireEvent(this.session, (DocumentRouteElement)routeInstance, props, DocumentRoutingConstants.Events.afterRouteReady.name());
        routeInstance.save(this.session);
        if (Framework.isTestModeSet()) {
            ((EventService)Framework.getLocalService(EventService.class)).waitForAsyncCompletion();
        }
        if (this.startInstance) {
            this.fireEvent(this.session, (DocumentRouteElement)routeInstance, null, DocumentRoutingConstants.Events.beforeRouteStart.name());
            this.getEngineService().start(routeInstance, this.session);
        }
    }

    public DocumentRoute getInstance() {
        return (DocumentRoute)this.instance.getAdapter(DocumentRoute.class);
    }

    protected DocumentRoutingEngineService getEngineService() {
        try {
            return (DocumentRoutingEngineService)Framework.getService(DocumentRoutingEngineService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected void fireEvent(CoreSession coreSession, DocumentRouteElement element, Map<String, Serializable> eventProperties, String eventName) {
        if (eventProperties == null) {
            eventProperties = new HashMap<String, Serializable>();
        }
        eventProperties.put("documentElementEventContextKey", (Serializable)element);
        eventProperties.put("category", (Serializable)((Object)"Routing"));
        DocumentEventContext envContext = new DocumentEventContext(coreSession, coreSession.getPrincipal(), element.getDocument());
        envContext.setProperties(eventProperties);
        try {
            this.getEventProducer().fireEvent(envContext.newEvent(eventName));
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    protected EventProducer getEventProducer() {
        try {
            return (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

