/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xslt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.XMLException;
import nu.xom.xslt.XOMResult;
import nu.xom.xslt.XOMSource;
import nu.xom.xslt.XSLException;
import org.xml.sax.SAXParseException;

public final class XSLTransform {
    private Templates templates;
    private NodeFactory factory;
    private Map parameters = new HashMap();
    private static ErrorListener errorsAreFatal = new FatalListener();

    private XSLTransform(Source source) throws XSLException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setErrorListener(errorsAreFatal);
            this.templates = factory.newTemplates(source);
        }
        catch (TransformerFactoryConfigurationError error) {
            throw new XSLException("Could not locate a TrAX TransformerFactory", error);
        }
        catch (TransformerConfigurationException ex) {
            throw new XSLException("Syntax error in stylesheet", ex);
        }
    }

    public XSLTransform(Document stylesheet) throws XSLException {
        this(stylesheet, new NodeFactory());
    }

    public XSLTransform(Document stylesheet, NodeFactory factory) throws XSLException {
        this(new XOMSource(stylesheet));
        this.factory = factory == null ? new NodeFactory() : factory;
    }

    public Nodes transform(Document in) throws XSLException {
        return this.transform(new XOMSource(in));
    }

    public void setParameter(String name, Object value) {
        this.setParameter(name, null, value);
    }

    public void setParameter(String name, String namespace, Object value) {
        if (namespace == null || "".equals(namespace)) {
            this._setParameter(name, value);
        } else {
            this._setParameter("{" + namespace + "}" + name, value);
        }
    }

    private void _setParameter(String name, Object value) {
        if (value == null) {
            this.parameters.remove(name);
        } else {
            this.parameters.put(name, value);
        }
    }

    public Nodes transform(Nodes in) throws XSLException {
        if (in.size() == 0) {
            return new Nodes();
        }
        XOMSource source = new XOMSource(in);
        return this.transform(source);
    }

    private Nodes transform(Source in) throws XSLException {
        try {
            XOMResult out = new XOMResult(this.factory);
            Transformer transformer = this.templates.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setErrorListener(errorsAreFatal);
            Iterator iterator = this.parameters.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = this.parameters.get(key);
                transformer.setParameter(key, value);
            }
            transformer.transform(in, out);
            return out.getResult();
        }
        catch (Exception ex) {
            TransformerException tex;
            Throwable nested;
            Throwable cause = ex;
            if (cause instanceof TransformerException && (nested = (tex = (TransformerException)cause).getException()) != null && (cause = nested) instanceof SAXParseException && (nested = ((SAXParseException)cause).getException()) != null) {
                cause = nested;
            }
            throw new XSLException(ex.getMessage(), cause);
        }
    }

    public static Document toDocument(Nodes nodes) {
        int i;
        Element root = null;
        int rootPosition = 0;
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            if (!(nodes.get(i2) instanceof Element)) continue;
            rootPosition = i2;
            root = (Element)nodes.get(i2);
            break;
        }
        if (root == null) {
            throw new XMLException("No root element");
        }
        Document result = new Document(root);
        for (i = 0; i < rootPosition; ++i) {
            result.insertChild(nodes.get(i), i);
        }
        for (i = rootPosition + 1; i < nodes.size(); ++i) {
            result.appendChild(nodes.get(i));
        }
        return result;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": " + this.templates + "]";
    }

    private static class FatalListener
    implements ErrorListener {
        private FatalListener() {
        }

        public void warning(TransformerException exception) {
        }

        public void error(TransformerException exception) throws TransformerException {
            throw exception;
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            throw exception;
        }
    }
}

