/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.TripleSorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTripleSorter
implements TripleSorter {
    private Triple[] result;
    private int putIndex;
    private Set<Node> bound;
    private List<Triple> remaining;

    public SimpleTripleSorter() {
    }

    @Override
    public Triple[] sort(Triple[] ts) {
        return new SimpleTripleSorter(ts).sort();
    }

    protected SimpleTripleSorter(Triple[] triples) {
        this();
        this.bound = new HashSet<Node>();
        this.result = new Triple[triples.length];
        this.remaining = new ArrayList<Triple>(Arrays.asList(triples));
    }

    protected Triple[] sort() {
        while (this.remaining.size() > 0) {
            this.accept(this.findMostBinding(this.findLightest(this.remaining)));
        }
        return this.result;
    }

    protected void accept(Triple t) {
        this.result[this.putIndex++] = t;
        this.bind(t);
        this.remaining.remove(t);
    }

    protected List<Triple> findLightest(List<Triple> candidates) {
        ArrayList<Triple> lightest = new ArrayList<Triple>();
        int minWeight = 100;
        for (int i = 0; i < candidates.size(); ++i) {
            Triple t = candidates.get(i);
            int w = this.weight(t);
            if (w < minWeight) {
                lightest.clear();
                lightest.add(t);
                minWeight = w;
                continue;
            }
            if (w != minWeight) continue;
            lightest.add(t);
        }
        return lightest;
    }

    protected Triple findMostBinding(List<Triple> candidates) {
        int maxBinding = -1;
        Triple mostBinding = null;
        for (int i = 0; i < candidates.size(); ++i) {
            Triple t = candidates.get(i);
            int count = this.bindingCount(t);
            if (count <= maxBinding) continue;
            mostBinding = t;
            maxBinding = count;
        }
        return mostBinding;
    }

    protected int bindingCount(Triple t) {
        int count = 0;
        for (int i = 0; i < this.remaining.size(); ++i) {
            Triple other = this.remaining.get(i);
            if (other == t) continue;
            count += this.bindingCount(t, other);
        }
        return count;
    }

    protected int bindingCount(Triple t, Triple other) {
        return this.bindingCount(t.getSubject(), other) + this.bindingCount(t.getPredicate(), other) + this.bindingCount(t.getObject(), other);
    }

    protected int bindingCount(Node n, Triple o) {
        return n.isVariable() ? this.bc(n, o.getSubject()) + this.bc(n, o.getPredicate()) + this.bc(n, o.getObject()) : 0;
    }

    protected int bc(Node n, Node other) {
        return n.equals(other) ? 1 : 0;
    }

    protected void bind(Triple t) {
        this.bind(t.getSubject());
        this.bind(t.getPredicate());
        this.bind(t.getObject());
    }

    protected void bind(Node n) {
        if (n.isVariable()) {
            this.bound.add(n);
        }
    }

    protected int weight(Triple t) {
        return this.weight(t.getSubject()) + this.weight(t.getPredicate()) + this.weight(t.getObject());
    }

    protected int weight(Node n) {
        return n.isConcrete() ? 0 : (n.equals(Node.ANY) ? 5 : (this.bound.contains(n) ? 1 : 4));
    }
}

