/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.caselink;

import java.io.Serializable;
import java.util.Calendar;
import java.util.UUID;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.runtime.api.Framework;

public class CreateDraftCaseLinkUnrestricted
extends UnrestrictedSessionRunner {
    protected CaseLink createdPost;
    protected final String subject;
    protected final Case envelope;
    protected final Mailbox sender;

    public CaseLink getCreatedPost() {
        return this.createdPost;
    }

    public CreateDraftCaseLinkUnrestricted(String repositoryName, String subject, Case envelope, Mailbox sender) {
        super(repositoryName);
        this.envelope = envelope;
        this.subject = subject;
        this.sender = sender;
    }

    public void run() throws ClientException {
        CaseManagementDocumentTypeService correspDocumentTypeService;
        try {
            correspDocumentTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        DocumentModel doc = this.session.createDocumentModel(this.sender.getDocument().getPathAsString(), UUID.randomUUID().toString(), correspDocumentTypeService.getCaseLinkType());
        this.setPostValues(doc);
        doc = this.session.createDocument(doc);
        this.createdPost = (CaseLink)doc.getAdapter(CaseLink.class);
    }

    protected void setPostValues(DocumentModel doc) throws ClientException {
        doc.setPropertyValue("cslk:draft", (Serializable)Boolean.valueOf(true));
        doc.setPropertyValue("dc:title", (Serializable)((Object)this.subject));
        doc.setPropertyValue("cslk:caseRepositoryName", (Serializable)((Object)this.envelope.getDocument().getRepositoryName()));
        doc.setPropertyValue("cslk:caseDocumentId", (Serializable)((Object)this.envelope.getDocument().getId()));
        doc.setPropertyValue("cslk:senderMailboxId", (Serializable)((Object)this.sender.getId()));
        doc.setPropertyValue("cslk:date", (Serializable)Calendar.getInstance().getTime());
        doc.setPropertyValue("cslk:sender", (Serializable)((Object)this.sender.getId()));
        doc.setPropertyValue("cslk:isSent", (Serializable)Boolean.valueOf(false));
    }
}

