/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event;

import java.util.List;
import java.util.Map;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.cases.HasParticipants;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;

public class AfterCaseSentEventListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        Map properties = event.getContext().getProperties();
        Case kase = (Case)properties.get("eventContextCase");
        if (kase == null) {
            return;
        }
        Map internalRecipients = (Map)properties.get("eventContextParticipants");
        Map externalRecipients = (Map)properties.get("eventContextExternalParticipants");
        boolean isInitial = (Boolean)properties.get("eventContextIsInitial");
        this.setRecipients((HasParticipants)kase, isInitial, internalRecipients, externalRecipients);
        kase.save(event.getContext().getCoreSession());
        List items = kase.getCaseItems(event.getContext().getCoreSession());
        for (CaseItem item : items) {
            this.setRecipients((HasParticipants)item, isInitial, internalRecipients, externalRecipients);
            item.setDefaultCase(kase.getDocument().getId());
            item.save(event.getContext().getCoreSession());
        }
        try {
            kase.save(event.getContext().getCoreSession());
        }
        catch (Exception e) {
            ClientException.wrap((Throwable)e);
        }
    }

    protected void setRecipients(HasParticipants item, boolean isInitial, Map<String, List<String>> internalRecipients, Map<String, List<String>> externalRecipients) {
        if (isInitial) {
            item.addInitialInternalParticipants(internalRecipients);
            item.addInitialExternalParticipants(externalRecipients);
        }
        item.addParticipants(internalRecipients);
        item.addParticipants(externalRecipients);
    }
}

