/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.mailbox.MailboxConstants;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class CreateMailboxIdListener
implements EventListener {
    private static final Log log = LogFactory.getLog(CreateMailboxIdListener.class);

    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext docCtx = null;
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        docCtx = (DocumentEventContext)event.getContext();
        DocumentModel doc = docCtx.getSourceDocument();
        CoreSession session = docCtx.getCoreSession();
        if (session == null) {
            return;
        }
        Mailbox mb = (Mailbox)doc.getAdapter(Mailbox.class);
        if (mb == null || mb.getId() != null) {
            return;
        }
        try {
            MailboxManagementService correspService = (MailboxManagementService)Framework.getService(MailboxManagementService.class);
            this.setIdForMailbox(session, correspService, mb);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    protected void setIdForMailbox(CoreSession session, MailboxManagementService correspService, Mailbox mb) {
        if (correspService == null) {
            log.error((Object)"Cannot set mailbox id: casemanagement service is null");
            return;
        }
        String id = null;
        if (MailboxConstants.type.personal.name().equals(mb.getType())) {
            String owner = mb.getOwner();
            if (owner == null) {
                log.warn((Object)"Creating a personal mailbox without owner");
            } else {
                id = correspService.getUserPersonalMailboxId(owner);
            }
        }
        if (id == null) {
            String title = mb.getTitle();
            if (title != null) {
                id = IdUtils.generateId((String)title);
                if (correspService.hasMailbox(session, id)) {
                    id = id + "_" + new Date().getTime();
                }
            } else {
                id = String.valueOf(new Date().getTime());
            }
        }
        mb.setId(id);
    }
}

