/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event.synchronization;

import java.util.Calendar;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.core.event.synchronization.AbstractSyncMailboxListener;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class MailboxDeletedListener
extends AbstractSyncMailboxListener {
    private static final Log log = LogFactory.getLog(MailboxDeletedListener.class);

    public void handleEvent(Event event) throws ClientException {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            throw new ClientException("Could not get Document from event");
        }
        DocumentEventContext docEventContext = (DocumentEventContext)event.getContext();
        Map properties = docEventContext.getProperties();
        Calendar synchronizeDate = (Calendar)properties.get("eventContextSynchronizedDate");
        CoreSession session = docEventContext.getCoreSession();
        DocumentModel sourceDoc = docEventContext.getSourceDocument();
        this.deleteDoc(sourceDoc, synchronizeDate, session);
    }

    private void deleteDoc(DocumentModel doc, Calendar synchronizeDate, CoreSession session) throws ClientException {
        if (doc.getAllowedStateTransitions().contains("delete")) {
            doc.followTransition("delete");
            log.debug((Object)("Deleted " + doc.getName()));
            Mailbox cf = (Mailbox)doc.getAdapter(Mailbox.class);
            cf.setLastSyncUpdate(synchronizeDate);
            cf.save(session);
        }
    }
}

