/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service.synchronization;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.exception.CaseManagementException;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.mailbox.MailboxConstants;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.cm.service.MailboxTitleGenerator;
import org.nuxeo.cm.service.synchronization.MailboxDirectorySynchronizationDescriptor;
import org.nuxeo.cm.service.synchronization.MailboxGroupSynchronizationDescriptor;
import org.nuxeo.cm.service.synchronization.MailboxSynchronizationConstants;
import org.nuxeo.cm.service.synchronization.MailboxSynchronizationService;
import org.nuxeo.cm.service.synchronization.MailboxUserSynchronizationDescriptor;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.UnboundEventContext;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class MailboxSynchronizationServiceImpl
extends DefaultComponent
implements MailboxSynchronizationService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MailboxSynchronizationService.class);
    protected static final String QUERY_GET_MAILBOX_FROM_ID = "SELECT * FROM Mailbox WHERE mlbx:synchronizerId= '%s'";
    protected static final String QUERY_GET_MAILBOX_FROM_TITLE = "SELECT * FROM Mailbox WHERE dc:title= '%s'";
    protected static final String QUERY_GET_DELETED_MAILBOX = "SELECT * FROM Mailbox WHERE mlbx:origin= '%s'  AND mlbx:lastSyncUpdate < TIMESTAMP '%s' AND ecm:currentLifeCycleState != 'deleted'";
    protected EventProducer eventProducer;
    protected final Map<String, MailboxDirectorySynchronizationDescriptor> directorySynchronizer = new HashMap<String, MailboxDirectorySynchronizationDescriptor>();
    protected MailboxUserSynchronizationDescriptor userSynchronizer;
    protected MailboxGroupSynchronizationDescriptor groupSynchronizer;
    protected int count;
    protected int total;
    protected int batchSize = 100;
    protected boolean deleteOldMailboxes;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (contribution instanceof MailboxDirectorySynchronizationDescriptor) {
            MailboxDirectorySynchronizationDescriptor synchronizer = (MailboxDirectorySynchronizationDescriptor)contribution;
            String directoryName = synchronizer.getDirectoryName();
            MailboxDirectorySynchronizationDescriptor existingDirSynchronizer = this.directorySynchronizer.get(directoryName);
            if (existingDirSynchronizer == null) {
                if (synchronizer.getDirectoryEntryIdField() != null && synchronizer.getMailboxIdField() != null && synchronizer.getDirectoryName() != null && synchronizer.getTitleGenerator() != null) {
                    this.directorySynchronizer.put(synchronizer.getDirectoryName(), synchronizer);
                } else {
                    log.error((Object)"Could not register contribution because of missing field(s) in contribution");
                }
            } else {
                this.mergeDirectoryContribution(existingDirSynchronizer, synchronizer);
            }
        } else if (contribution instanceof MailboxGroupSynchronizationDescriptor) {
            MailboxGroupSynchronizationDescriptor synchronizer = (MailboxGroupSynchronizationDescriptor)contribution;
            if (synchronizer.getTitleGenerator() != null) {
                this.groupSynchronizer = synchronizer;
            } else {
                log.error((Object)"Could not register contribution because of missing field(s) in contribution");
            }
        } else if (contribution instanceof MailboxUserSynchronizationDescriptor) {
            MailboxUserSynchronizationDescriptor synchronizer = (MailboxUserSynchronizationDescriptor)contribution;
            if (synchronizer.getTitleGenerator() != null) {
                this.userSynchronizer = synchronizer;
            } else {
                log.error((Object)"Could not register contribution because of missing field(s) in contribution");
            }
        }
    }

    protected MailboxDirectorySynchronizationDescriptor mergeDirectoryContribution(MailboxDirectorySynchronizationDescriptor existingDirSynchronizer, MailboxDirectorySynchronizationDescriptor synchronizer) throws InstantiationException, IllegalAccessException {
        existingDirSynchronizer.setEnabled(synchronizer.isEnabled());
        if (synchronizer.getMailboxIdField() != null) {
            existingDirSynchronizer.setMailboxIdField(synchronizer.getMailboxIdField());
        }
        if (synchronizer.getChildrenField() != null) {
            existingDirSynchronizer.setChildrenField(synchronizer.getChildrenField());
        }
        if (synchronizer.getDirectoryEntryIdField() != null) {
            existingDirSynchronizer.setDirectoryEntryIdField(synchronizer.getDirectoryEntryIdField());
        }
        if (synchronizer.getTitleGenerator() != null) {
            existingDirSynchronizer.setTitleGenerator(synchronizer.getTitleGenerator());
        }
        return existingDirSynchronizer;
    }

    public Map<String, MailboxDirectorySynchronizationDescriptor> getSynchronizerMap() {
        return this.directorySynchronizer;
    }

    public MailboxUserSynchronizationDescriptor getUserSynchronizer() {
        return this.userSynchronizer;
    }

    public MailboxGroupSynchronizationDescriptor getGroupSynchronizer() {
        return this.groupSynchronizer;
    }

    public void doSynchronize() throws Exception {
        RepositoryManager mgr;
        try {
            mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        if (mgr == null) {
            throw new CaseManagementRuntimeException("Cannot find RepositoryManager");
        }
        String batchSize = Framework.getProperty((String)"cm.mailboxes.updateBatchSize");
        if (batchSize != null && !"".equals(batchSize)) {
            this.batchSize = Integer.parseInt(batchSize);
        }
        this.deleteOldMailboxes = Boolean.parseBoolean(Framework.getProperty((String)"cm.syncro.delete.mailboxes", (String)"false"));
        Repository repo = mgr.getDefaultRepository();
        SynchronizeSessionRunner runner = new SynchronizeSessionRunner(repo.getName());
        runner.runUnrestricted();
        this.flushJaasCache();
    }

    protected void flushJaasCache() {
        try {
            EventService eventService = (EventService)Framework.getService(EventService.class);
            if (eventService != null) {
                eventService.sendEvent(new Event("usermanager", "user_changed", (Object)this, null));
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    protected void synchronizeGroupList(Map<String, List<String>> groupMap, String directoryName, String directoryIdField, Calendar now, UserManager userManager, MailboxTitleGenerator titleGenerator, CoreSession coreSession, Boolean txStarted) throws ClientException {
        String type2 = MailboxConstants.type.generic.toString();
        Set<Map.Entry<String, List<String>>> groupSet = groupMap.entrySet();
        HashMap<String, List<String>> nextChildrenBatch = new HashMap<String, List<String>>();
        try {
            for (Map.Entry<String, List<String>> groupEntry : groupSet) {
                String parentSynchronizerId = groupEntry.getKey();
                List<String> groups = groupEntry.getValue();
                for (String groupName : groups) {
                    try {
                        DocumentModel groupModel = userManager.getGroupModel(groupName);
                        if (groupModel == null) {
                            log.error((Object)("Could not synchronize mailbox for user " + groupName));
                            continue;
                        }
                        String synchronizerId = String.format("%s:%s", directoryName, groupName);
                        String generatedTitle = titleGenerator.getMailboxTitle(groupModel);
                        this.synchronizeMailbox(groupModel, directoryName, userManager.getGroupSchemaName(), parentSynchronizerId, synchronizerId, groupName, generatedTitle, null, type2, now, coreSession);
                        List groupChilds = userManager.getGroupsInGroup(groupName);
                        if (groupChilds != null && !groupChilds.isEmpty()) {
                            nextChildrenBatch.put(synchronizerId, groupChilds);
                        }
                        if (++this.count % this.batchSize == 0 && txStarted.booleanValue()) {
                            log.debug((Object)"Transaction ended during Mailbox synchronization");
                            TransactionHelper.commitOrRollbackTransaction();
                            txStarted = TransactionHelper.startTransaction();
                            log.debug((Object)"New Transaction started during Mailbox synchronization");
                        }
                        log.debug((Object)String.format("Updated %d/%d group Mailboxes", this.count, this.total));
                    }
                    catch (DirectoryException de) {
                        Throwable t = ExceptionHelper.unwrapException((Throwable)de);
                        if (t.getMessage().contains("javax.naming.NameNotFoundException")) {
                            log.warn((Object)("Searched entry does not exist: " + groupName));
                            continue;
                        }
                        throw new CaseManagementRuntimeException("User synchronization failed", (Throwable)de);
                    }
                }
            }
            if (!nextChildrenBatch.isEmpty()) {
                this.synchronizeGroupList(nextChildrenBatch, directoryName, directoryIdField, now, userManager, titleGenerator, coreSession, txStarted);
            }
        }
        catch (Exception e) {
            if (txStarted.booleanValue()) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            throw new CaseManagementRuntimeException("Group synchronization failed", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void synchronizeUserList(List<String> userIds, String directoryName, String directoryIdField, Calendar now, UserManager userManager, MailboxTitleGenerator titleGenerator, CoreSession coreSession, Boolean txStarted) throws ClientException {
        String type2 = MailboxConstants.type.personal.toString();
        int total = userIds.size();
        try {
            for (String userId : userIds) {
                try {
                    DocumentModel userModel = userManager.getUserModel(userId);
                    if (userModel == null) {
                        log.error((Object)("Could not synchronize mailbox for user " + userId));
                        continue;
                    }
                    String synchronizerId = String.format("%s:%s", directoryName, userId);
                    String generatedTitle = titleGenerator.getMailboxTitle(userModel);
                    this.synchronizeMailbox(userModel, directoryName, userManager.getUserSchemaName(), "", synchronizerId, userId, generatedTitle, userId, type2, now, coreSession);
                    if (++this.count % this.batchSize == 0 && txStarted.booleanValue()) {
                        log.debug((Object)"Transaction ended during Mailbox synchronization");
                        TransactionHelper.commitOrRollbackTransaction();
                        txStarted = TransactionHelper.startTransaction();
                        log.debug((Object)"New Transaction started during Mailbox synchronization");
                    }
                    log.debug((Object)String.format("Updated %d/%d user Mailboxes", this.count, total));
                }
                catch (DirectoryException de) {
                    Throwable t = ExceptionHelper.unwrapException((Throwable)de);
                    if (!t.getMessage().contains("javax.naming.NameNotFoundException")) throw new CaseManagementRuntimeException("User synchronization failed", (Throwable)de);
                    log.warn((Object)("Searched entry does not exist: " + userId));
                    continue;
                    return;
                }
            }
        }
        catch (Exception e) {
            if (!txStarted.booleanValue()) throw new CaseManagementRuntimeException("User synchronization failed", (Throwable)e);
            TransactionHelper.setTransactionRollbackOnly();
            throw new CaseManagementRuntimeException("User synchronization failed", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void synchronizeMailbox(DocumentModel entry, String directoryName, String directorySchema, String parentSynchronizerId, String synchronizerId, String entryId, String generatedTitle, String owner, String type2, Calendar now, CoreSession coreSession) throws ClientException {
        DocumentModel cfDoc = this.getMailboxFromSynchronizerId(synchronizerId, coreSession);
        Mailbox cf = null;
        if (cfDoc != null) {
            cf = (Mailbox)cfDoc.getAdapter(Mailbox.class);
            synchronizerId = cf.getSynchronizerId();
        }
        HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
        eventProperties.put("eventContextSynchronizerEntryId", (Serializable)((Object)entryId));
        entry.putContextData("skipRefetchDocument", (Serializable)Boolean.TRUE);
        eventProperties.put("eventContextSynchronizerEntry", (Serializable)entry);
        eventProperties.put("eventContextDirectoryName", (Serializable)((Object)directoryName));
        eventProperties.put("eventContextDirectorySchemaName", (Serializable)((Object)directorySchema));
        eventProperties.put("eventContextMailboxParentSynchronizerId", (Serializable)((Object)parentSynchronizerId));
        eventProperties.put("eventContextSynchronizerId", (Serializable)((Object)synchronizerId));
        eventProperties.put("eventContextMailboxTitle", (Serializable)((Object)generatedTitle));
        eventProperties.put("eventContextMailboxOwner", (Serializable)((Object)owner));
        eventProperties.put("eventContextMailboxType", (Serializable)((Object)type2));
        eventProperties.put("eventContextSynchronizedDate", now);
        eventProperties.put("sessionId", (Serializable)((Object)coreSession.getSessionId()));
        if (cf != null) {
            Calendar lastSyncUpdate = cf.getLastSyncUpdate();
            if (lastSyncUpdate != null) {
                if (lastSyncUpdate.equals(now)) return;
            }
            if (cf.isSynchronized().booleanValue()) {
                cf.setLastSyncUpdate(now);
                coreSession.saveDocument(cfDoc);
                log.debug((Object)String.format("Update Mailbox %s", synchronizerId));
                this.notify(MailboxSynchronizationConstants.EventNames.onMailboxUpdated.toString(), cf.getDocument(), eventProperties, coreSession);
                return;
            }
            cf.setLastSyncUpdate(now);
            coreSession.saveDocument(cfDoc);
            log.debug((Object)String.format("set Unsynchronized state for Mailbox %s", synchronizerId));
            return;
        }
        cfDoc = this.getMailboxFromTitle(generatedTitle, coreSession);
        cf = null;
        if (cfDoc != null) {
            cf = (Mailbox)cfDoc.getAdapter(Mailbox.class);
        }
        if (cf == null) {
            log.debug((Object)String.format("Creates Mailbox %s", synchronizerId));
            DocumentModel mailboxModel = coreSession.createDocumentModel(this.getMailboxType());
            this.notify(MailboxSynchronizationConstants.EventNames.onMailboxCreated.toString(), mailboxModel, eventProperties, coreSession);
            return;
        }
        Calendar lastSyncUpdate = cf.getLastSyncUpdate();
        boolean setDoublon = false;
        if (lastSyncUpdate == null || !lastSyncUpdate.equals(now)) {
            if (cf.isSynchronized().booleanValue()) {
                cf.setSynchronizerId(synchronizerId);
                cf.setLastSyncUpdate(now);
                cf.setOrigin(directoryName);
                coreSession.saveDocument(cfDoc);
                log.debug((Object)String.format("Update Mailbox %s", synchronizerId));
                this.notify(MailboxSynchronizationConstants.EventNames.onMailboxUpdated.toString(), cf.getDocument(), eventProperties, coreSession);
            } else {
                setDoublon = true;
            }
        } else {
            setDoublon = true;
        }
        if (!setDoublon) return;
        cf.setSynchronizeState(MailboxSynchronizationConstants.synchronisedState.doublon.toString());
        cf.setLastSyncUpdate(now);
        coreSession.saveDocument(cfDoc);
        log.debug((Object)String.format("set Doublon state for Mailbox %s", synchronizerId));
    }

    protected String getMailboxType() throws ClientException {
        CaseManagementDocumentTypeService correspDocumentTypeService;
        try {
            correspDocumentTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        return correspDocumentTypeService.getMailboxType();
    }

    protected void handleDeletedMailboxes(String directoryName, Calendar now, CoreSession coreSession) throws ClientException {
        String dateLiteral = DateLiteral.dateTimeFormatter.print(now.getTimeInMillis());
        String query = String.format(QUERY_GET_DELETED_MAILBOX, directoryName, dateLiteral);
        DocumentModelList deletedMailboxes = coreSession.query(query);
        if (deletedMailboxes == null) {
            return;
        }
        for (DocumentModel mailboxDoc : deletedMailboxes) {
            Mailbox cf = (Mailbox)mailboxDoc.getAdapter(Mailbox.class);
            if (cf == null) {
                log.error((Object)String.format("Could not get Mailbox adapter for doc %s", mailboxDoc.getId()));
                continue;
            }
            String synchronizerId = cf.getSynchronizerId();
            HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
            eventProperties.put("eventContextDirectoryName", (Serializable)((Object)directoryName));
            eventProperties.put("eventContextSynchronizerId", (Serializable)((Object)synchronizerId));
            eventProperties.put("eventContextMailboxTitle", (Serializable)((Object)mailboxDoc.getTitle()));
            eventProperties.put("eventContextSynchronizedDate", now);
            log.debug((Object)String.format("Mailbox %s has been remove from directory, deleting it.", synchronizerId));
            this.notify(MailboxSynchronizationConstants.EventNames.onMailboxDeleted.toString(), mailboxDoc, eventProperties, coreSession);
        }
    }

    protected DocumentModel getMailboxFromSynchronizerId(String id, CoreSession coreSession) throws ClientException {
        String query = String.format(QUERY_GET_MAILBOX_FROM_ID, this.escape(id));
        DocumentModelList mailboxDocs = coreSession.query(query);
        if (mailboxDocs == null || mailboxDocs.isEmpty()) {
            log.debug((Object)String.format("Mailbox with id %s does not exist", id));
            return null;
        }
        if (mailboxDocs.size() > 1) {
            log.error((Object)String.format("Found more than one Mailbox for id %s", id));
            return null;
        }
        DocumentModel mailboxDoc = (DocumentModel)mailboxDocs.get(0);
        return mailboxDoc;
    }

    protected DocumentModel getMailboxFromTitle(String title, CoreSession coreSession) throws ClientException {
        String query = String.format(QUERY_GET_MAILBOX_FROM_TITLE, this.escape(title));
        DocumentModelList mailboxDocs = coreSession.query(query);
        if (mailboxDocs == null || mailboxDocs.isEmpty()) {
            log.debug((Object)String.format("Mailbox with title %s does not exist", title));
            return null;
        }
        if (mailboxDocs.size() > 1) {
            log.debug((Object)String.format("Found more than one Mailbox for Title %s, uses first found.", title));
        }
        DocumentModel mailboxDoc = (DocumentModel)mailboxDocs.get(0);
        return mailboxDoc;
    }

    protected String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '+' || c == '!' || c == '\"' || c == '\'') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void notify(String name, DocumentModel document, Map<String, Serializable> eventProperties, CoreSession session) {
        Object envContext = document == null ? new UnboundEventContext(session, session.getPrincipal(), null) : new DocumentEventContext(session, session.getPrincipal(), document);
        envContext.setProperties(eventProperties);
        try {
            this.getEventProducer().fireEvent(envContext.newEvent(name));
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected EventProducer getEventProducer() throws Exception {
        if (this.eventProducer == null) {
            this.eventProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        return this.eventProducer;
    }

    private class SynchronizeSessionRunner
    extends UnrestrictedSessionRunner {
        public SynchronizeSessionRunner(String repository) {
            super(repository);
        }

        public void run() throws ClientException {
            String directoryIdField;
            String directoryName;
            Calendar now;
            MailboxTitleGenerator titleGenerator;
            UserManager userManager;
            try {
                userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                throw new CaseManagementRuntimeException((Throwable)e);
            }
            if (userManager == null) {
                throw new CaseManagementException("User manager not found");
            }
            if (MailboxSynchronizationServiceImpl.this.groupSynchronizer != null && MailboxSynchronizationServiceImpl.this.groupSynchronizer.isEnabled().booleanValue()) {
                try {
                    titleGenerator = MailboxSynchronizationServiceImpl.this.groupSynchronizer.getTitleGenerator();
                }
                catch (Exception e) {
                    throw new CaseManagementRuntimeException((Throwable)e);
                }
                if (titleGenerator != null) {
                    now = Calendar.getInstance();
                    directoryName = userManager.getGroupDirectoryName();
                    directoryIdField = userManager.getGroupIdField();
                    List topLevelgroups = userManager.getTopLevelGroups();
                    HashMap<String, List<String>> topBatch = new HashMap<String, List<String>>();
                    topBatch.put("", topLevelgroups);
                    log.info((Object)"Start groups synchronization");
                    MailboxSynchronizationServiceImpl.this.count = 0;
                    MailboxSynchronizationServiceImpl.this.total = userManager.getGroupIds().size();
                    boolean txStarted = false;
                    try {
                        if (TransactionHelper.isTransactionActive()) {
                            TransactionHelper.commitOrRollbackTransaction();
                            log.debug((Object)"Commiting existing transaction before Mailbox (group) synchronization");
                        }
                        txStarted = TransactionHelper.startTransaction();
                        log.debug((Object)"New Transaction started during Mailbox (group) synchronization");
                        MailboxSynchronizationServiceImpl.this.synchronizeGroupList(topBatch, directoryName, directoryIdField, now, userManager, titleGenerator, this.session, txStarted);
                    }
                    catch (Exception e) {
                        if (txStarted) {
                            TransactionHelper.setTransactionRollbackOnly();
                        }
                        throw new CaseManagementRuntimeException("Group synchronization failed", (Throwable)e);
                    }
                    finally {
                        if (txStarted) {
                            TransactionHelper.commitOrRollbackTransaction();
                            log.debug((Object)"Transaction ended during Mailbox synchronization");
                        }
                    }
                    if (MailboxSynchronizationServiceImpl.this.deleteOldMailboxes) {
                        log.info((Object)"Looking for deleted group entries");
                        MailboxSynchronizationServiceImpl.this.handleDeletedMailboxes(directoryName, now, this.session);
                    }
                    log.info((Object)"Group directory has been synchronized");
                } else {
                    log.error((Object)"Could not find GroupTitleGenerator, abort group directory synchronization.");
                }
            }
            if (MailboxSynchronizationServiceImpl.this.userSynchronizer != null && MailboxSynchronizationServiceImpl.this.userSynchronizer.isEnabled().booleanValue()) {
                try {
                    titleGenerator = MailboxSynchronizationServiceImpl.this.userSynchronizer.getTitleGenerator();
                }
                catch (Exception e) {
                    throw new CaseManagementRuntimeException((Throwable)e);
                }
                if (titleGenerator != null) {
                    now = new GregorianCalendar();
                    directoryName = userManager.getUserDirectoryName();
                    directoryIdField = userManager.getUserIdField();
                    List userIds = userManager.getUserIds();
                    log.debug((Object)"Start users synchronization");
                    MailboxSynchronizationServiceImpl.this.count = 0;
                    MailboxSynchronizationServiceImpl.this.total = userIds.size();
                    boolean txStarted = false;
                    try {
                        if (TransactionHelper.isTransactionActive()) {
                            TransactionHelper.commitOrRollbackTransaction();
                            log.debug((Object)"Commiting existing transaction before Mailbox (user) synchronization");
                        }
                        txStarted = TransactionHelper.startTransaction();
                        log.debug((Object)"New Transaction started during Mailbox (user) synchronization");
                        MailboxSynchronizationServiceImpl.this.synchronizeUserList(userIds, directoryName, directoryIdField, now, userManager, titleGenerator, this.session, txStarted);
                    }
                    catch (Exception e) {
                        if (txStarted) {
                            TransactionHelper.setTransactionRollbackOnly();
                        }
                        throw new CaseManagementRuntimeException("User synchronization failed", (Throwable)e);
                    }
                    finally {
                        if (txStarted) {
                            TransactionHelper.commitOrRollbackTransaction();
                            log.debug((Object)"Transaction ended during Mailbox synchronization");
                        }
                    }
                    log.debug((Object)String.format("Updated %d/%d mailboxes", MailboxSynchronizationServiceImpl.this.count, MailboxSynchronizationServiceImpl.this.total));
                    if (MailboxSynchronizationServiceImpl.this.deleteOldMailboxes) {
                        MailboxSynchronizationServiceImpl.this.handleDeletedMailboxes(directoryName, now, this.session);
                    }
                    log.info((Object)"User directory has been synchronized");
                } else {
                    log.error((Object)"Could not find UserTitleGenerator, abort user directory synchronization.");
                }
            }
        }
    }
}

