/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding.alias;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.MetaTagHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.jsf.ComponentSupport;
import java.io.IOException;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasVariableMapper;
import org.nuxeo.ecm.platform.ui.web.binding.alias.UIAliasHolder;

public class AliasTagHandler
extends MetaTagHandler {
    protected final TagAttribute cache;
    protected final TagAttribute id = this.getAttribute("id");
    protected final Map<String, ValueExpression> variables;

    public AliasTagHandler(TagConfig config, Map<String, ValueExpression> variables) {
        super(config);
        this.cache = this.getAttribute("cache");
        this.variables = variables;
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent == null) {
            throw new TagException(this.tag, "Parent UIComponent was null");
        }
        boolean cacheValue = false;
        if (this.cache != null) {
            cacheValue = this.cache.getBoolean(ctx);
        }
        AliasVariableMapper target = new AliasVariableMapper();
        if (this.variables != null) {
            for (Map.Entry<String, ValueExpression> var : this.variables.entrySet()) {
                if (cacheValue) {
                    Object res = var.getValue().getValue((ELContext)ctx);
                    target.setVariable(var.getKey(), ctx.getExpressionFactory().createValueExpression(res, Object.class));
                    continue;
                }
                target.setVariable(var.getKey(), var.getValue());
            }
        }
        this.apply(ctx, parent, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent, AliasVariableMapper alias) throws IOException, FacesException, FaceletException, ELException {
        String id = ctx.generateUniqueId(this.tagId);
        alias.setId(id);
        VariableMapper orig = ctx.getVariableMapper();
        VariableMapper vm = alias.getVariableMapperForBuild(orig);
        ctx.setVariableMapper(vm);
        Object c = ComponentSupport.findChildByTagId((UIComponent)parent, (String)id);
        boolean componentFound = false;
        if (c != null) {
            componentFound = true;
            ComponentSupport.markForDeletion((UIComponent)c);
        } else {
            c = new UIAliasHolder();
            c.getAttributes().put("com.sun.facelets.MARK_ID", id);
            if (this.id != null) {
                c.setId(this.id.getValue(ctx));
            } else {
                UIViewRoot root = ComponentSupport.getViewRoot((FaceletContext)ctx, (UIComponent)parent);
                if (root != null) {
                    String uid = root.createUniqueId();
                    c.setId(uid);
                }
            }
        }
        c.setValueExpression("value", ctx.getExpressionFactory().createValueExpression((Object)alias, AliasVariableMapper.class));
        FacesContext facesContext = ctx.getFacesContext();
        try {
            AliasVariableMapper.exposeAliasesToRequest(facesContext, alias);
            this.nextHandler.apply(ctx, c);
        }
        finally {
            AliasVariableMapper.removeAliasesExposedToRequest(facesContext, id);
            ctx.setVariableMapper(orig);
        }
        if (componentFound) {
            ComponentSupport.finalizeForDeletion((UIComponent)c);
        }
        parent.getChildren().add(c);
    }
}

