/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.CompoundFilter;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.impl.LifeCycleFilter;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;

public class RootSectionsFinder
extends UnrestrictedSessionRunner {
    protected static final String SCHEMA_PUBLISHING = "publishing";
    protected static final String SECTIONS_PROPERTY_NAME = "publish:sections";
    protected Set<String> sectionRootTypes;
    protected Set<String> sectionTypes;
    protected CoreSession userSession;
    protected List<String> unrestrictedSectionRootFromWorkspaceConfig;
    protected List<String> unrestrictedDefaultSectionRoot;
    protected DocumentModelList accessibleSectionRoots;
    protected DocumentModel currentDocument;
    private static final Log log = LogFactory.getLog(RootSectionsFinder.class);

    public RootSectionsFinder(CoreSession userSession, Set<String> sectionRootTypes, Set<String> sectionTypes) {
        super(userSession);
        this.sectionRootTypes = sectionRootTypes;
        this.userSession = userSession;
        this.sectionTypes = sectionTypes;
    }

    public void reset() {
        this.currentDocument = null;
    }

    public DocumentModelList getAccessibleSectionRoots(DocumentModel currentDoc) throws ClientException {
        if (this.currentDocument == null || !this.currentDocument.getRef().equals(currentDoc.getRef())) {
            this.computeUserSectionRoots(currentDoc);
        }
        return this.accessibleSectionRoots;
    }

    public DocumentModelList getSectionRootsForWorkspace(DocumentModel currentDoc, boolean addDefaultSectionRoots) throws ClientException {
        if (this.currentDocument == null || !this.currentDocument.getRef().equals(currentDoc.getRef())) {
            this.computeUserSectionRoots(currentDoc);
        }
        if (this.unrestrictedDefaultSectionRoot.isEmpty() && addDefaultSectionRoots && (this.unrestrictedDefaultSectionRoot == null || this.unrestrictedDefaultSectionRoot.isEmpty())) {
            DocumentModelList defaultSectionRoots = this.getDefaultSectionRoots(this.session);
            this.unrestrictedDefaultSectionRoot = new ArrayList<String>();
            for (DocumentModel root : defaultSectionRoots) {
                this.unrestrictedDefaultSectionRoot.add(root.getPathAsString());
            }
        }
        return this.getFiltredSectionRoots(this.unrestrictedSectionRootFromWorkspaceConfig, true);
    }

    public DocumentModelList getSectionRootsForWorkspace(DocumentModel currentDoc) throws ClientException {
        return this.getSectionRootsForWorkspace(currentDoc, false);
    }

    public DocumentModelList getDefaultSectionRoots(boolean onlyHeads, boolean addDefaultSectionRoots) throws ClientException {
        if (this.unrestrictedDefaultSectionRoot == null) {
            this.computeUserSectionRoots(null);
        }
        if (this.unrestrictedDefaultSectionRoot.isEmpty() && addDefaultSectionRoots && (this.unrestrictedDefaultSectionRoot == null || this.unrestrictedDefaultSectionRoot.isEmpty())) {
            DocumentModelList defaultSectionRoots = this.getDefaultSectionRoots(this.session);
            this.unrestrictedDefaultSectionRoot = new ArrayList<String>();
            for (DocumentModel root : defaultSectionRoots) {
                this.unrestrictedDefaultSectionRoot.add(root.getPathAsString());
            }
        }
        return this.getFiltredSectionRoots(this.unrestrictedDefaultSectionRoot, onlyHeads);
    }

    public DocumentModelList getDefaultSectionRoots(boolean onlyHeads) throws ClientException {
        return this.getDefaultSectionRoots(onlyHeads, false);
    }

    protected void computeUserSectionRoots(DocumentModel currentDoc) throws ClientException {
        this.currentDocument = currentDoc;
        this.runUnrestricted();
        if (currentDoc != null) {
            this.accessibleSectionRoots = !this.unrestrictedSectionRootFromWorkspaceConfig.isEmpty() ? this.getFiltredSectionRoots(this.unrestrictedSectionRootFromWorkspaceConfig, true) : this.getFiltredSectionRoots(this.unrestrictedDefaultSectionRoot, true);
        }
    }

    protected DocumentModelList getFiltredSectionRoots(List<String> rootPaths, boolean onlyHeads) throws ClientException {
        ArrayList<Object> filtredDocRef = new ArrayList<Object>();
        ArrayList<DocumentRef> trashedDocRef = new ArrayList<DocumentRef>();
        for (String rootPath : rootPaths) {
            PathRef rootRef = new PathRef(rootPath);
            if (this.userSession.hasPermission((DocumentRef)rootRef, "Read")) {
                filtredDocRef.add(rootRef);
                continue;
            }
            DocumentModelList accessibleSections = this.userSession.query(this.buildQuery(rootPath));
            for (DocumentModel section : accessibleSections) {
                if (onlyHeads && (filtredDocRef.contains(section.getParentRef()) || trashedDocRef.contains(section.getParentRef()))) {
                    trashedDocRef.add(section.getRef());
                    continue;
                }
                filtredDocRef.add(section.getRef());
            }
        }
        DocumentModelList documents = this.userSession.getDocuments(filtredDocRef.toArray(new DocumentRef[filtredDocRef.size()]));
        return this.filterDocuments(documents);
    }

    protected DocumentModelList filterDocuments(DocumentModelList docs) {
        DocumentModelListImpl filteredDocuments = new DocumentModelListImpl();
        FacetFilter facetFilter = new FacetFilter(Arrays.asList("Folderish"), Arrays.asList("HiddenInNavigation"));
        LifeCycleFilter lfFilter = new LifeCycleFilter("deleted", false);
        CompoundFilter filter = new CompoundFilter(new Filter[]{facetFilter, lfFilter});
        for (DocumentModel doc : docs) {
            if (!filter.accept(doc)) continue;
            filteredDocuments.add((Object)doc);
        }
        return filteredDocuments;
    }

    protected String buildQuery(String path) {
        String query = "SELECT * FROM Document WHERE ecm:path STARTSWITH " + NXQLQueryBuilder.prepareStringLiteral((String)path, (boolean)true, (boolean)true) + " and (";
        int i = 0;
        for (String type : this.sectionTypes) {
            query = query + " ecm:primaryType = '" + type + "'";
            if (++i < this.sectionTypes.size()) {
                query = query + " or ";
                continue;
            }
            query = query + " )";
        }
        query = query + " order by ecm:path ";
        return query;
    }

    protected void computeUnrestrictedRoots(CoreSession session) throws ClientException {
        if (this.currentDocument != null) {
            DocumentModel parentDocumentModel = this.currentDocument;
            while (!parentDocumentModel.hasSchema(SCHEMA_PUBLISHING) && !"Root".equals(parentDocumentModel.getType())) {
                parentDocumentModel = session.getDocument(parentDocumentModel.getParentRef());
            }
            DocumentModelList sectionRootsFromWorkspaceConfig = this.getSectionRootsFromWorkspaceConfig(parentDocumentModel, session);
            this.unrestrictedSectionRootFromWorkspaceConfig = new ArrayList<String>();
            for (DocumentModel root : sectionRootsFromWorkspaceConfig) {
                this.unrestrictedSectionRootFromWorkspaceConfig.add(root.getPathAsString());
            }
        }
        if (this.unrestrictedDefaultSectionRoot == null) {
            this.unrestrictedDefaultSectionRoot = Collections.emptyList();
        }
    }

    protected DocumentModelList getDefaultSectionRoots(CoreSession session) throws ClientException {
        DocumentModelListImpl sectionRoots = new DocumentModelListImpl();
        DocumentModelList domains = session.getChildren(session.getRootDocument().getRef(), "Domain");
        for (DocumentModel domain : domains) {
            for (String sectionRootNameType : this.sectionRootTypes) {
                DocumentModelList children = session.getChildren(domain.getRef(), sectionRootNameType);
                sectionRoots.addAll((Collection)children);
            }
        }
        return sectionRoots;
    }

    private DocumentModelList getSectionRootsFromWorkspaceConfig(DocumentModel workspace, CoreSession session) throws ClientException {
        DocumentModelListImpl selectedSections = new DocumentModelListImpl();
        if (workspace.hasSchema(SCHEMA_PUBLISHING)) {
            String[] sectionIdsArray = (String[])workspace.getPropertyValue(SECTIONS_PROPERTY_NAME);
            List<Object> sectionIdsList = new ArrayList();
            if (sectionIdsArray != null && sectionIdsArray.length > 0) {
                sectionIdsList = Arrays.asList(sectionIdsArray);
            }
            if (sectionIdsList != null) {
                for (String currentSectionId : sectionIdsList) {
                    try {
                        DocumentModel sectionToAdd = session.getDocument((DocumentRef)new IdRef(currentSectionId));
                        selectedSections.add((Object)sectionToAdd);
                    }
                    catch (ClientException e) {
                        log.warn((Object)("Section with ID=" + currentSectionId + " not found for document with ID=" + workspace.getId()));
                    }
                }
            }
        }
        return selectedSections;
    }

    public void run() throws ClientException {
        this.computeUnrestrictedRoots(this.session);
    }
}

