/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.cm.caselink.CaseLinkType;
import org.nuxeo.cm.distribution.DistributionInfo;
import org.nuxeo.cm.distribution.MailingListDistributionInfo;
import org.nuxeo.cm.distribution.ParticipantItem;

public class CMFDistributionInfo
implements DistributionInfo {
    private static final long serialVersionUID = 6930633132089246322L;
    protected String mode;
    protected List<ParticipantItem> favoriteMailboxes;
    protected List<String> forActionMailboxes;
    protected List<String> forActionGroups;
    protected String[] forActionFunctions;
    protected List<String> forInformationMailboxes;
    protected List<String> forInformationGroups;
    protected List<MailingListDistributionInfo> mlInfos = new ArrayList<MailingListDistributionInfo>();
    protected String[] forInformationFunctions;
    protected String comment;

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public List<ParticipantItem> getFavoriteMailboxes() {
        return this.favoriteMailboxes;
    }

    @Override
    public void setFavoriteMailboxes(List<ParticipantItem> favoriteMailboxes) {
        this.favoriteMailboxes = favoriteMailboxes;
        Collections.sort(this.favoriteMailboxes, new Comparator<ParticipantItem>(){

            @Override
            public int compare(ParticipantItem o1, ParticipantItem o2) {
                int comp = 0;
                if (o1.getType() != null) {
                    comp = o1.getType().compareTo(o2.getType());
                } else if (o2.getType() != null) {
                    return -1;
                }
                if (comp == 0 && o1.getTitle() != null) {
                    comp = o1.getTitle().compareTo(o2.getTitle());
                }
                return comp;
            }
        });
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<String> getForActionMailboxes() {
        return this.forActionMailboxes;
    }

    public void setForActionMailboxes(List<String> forActionPersonalMailboxes) {
        this.forActionMailboxes = forActionPersonalMailboxes;
    }

    public List<String> getForInformationMailboxes() {
        return this.forInformationMailboxes;
    }

    public void setForInformationMailboxes(List<String> forInformationPersonalMailboxes) {
        this.forInformationMailboxes = forInformationPersonalMailboxes;
    }

    public void setForActionFunctions(String[] forActionFunctions) {
        this.forActionFunctions = forActionFunctions;
    }

    public void setForInformationFunctions(String[] forInformationFunctions) {
        this.forInformationFunctions = forInformationFunctions;
    }

    public List<String> getAllForActionMailboxes() {
        String type2 = CaseLinkType.FOR_ACTION.getStringType();
        HashSet<String> mailboxes = new HashSet<String>();
        if (this.favoriteMailboxes != null && !this.favoriteMailboxes.isEmpty()) {
            for (ParticipantItem item : this.favoriteMailboxes) {
                if (!type2.equals(item.getType())) continue;
                mailboxes.add(item.getId());
            }
        }
        if (this.forActionMailboxes != null) {
            mailboxes.addAll(this.forActionMailboxes);
        }
        for (MailingListDistributionInfo mli : this.mlInfos) {
            if (!CaseLinkType.FOR_ACTION.name().equals(mli.getType())) continue;
            mailboxes.addAll(mli.getMailingList().getMailboxIds());
        }
        return new ArrayList<String>(mailboxes);
    }

    @Override
    public List<String> getForActionMailingLists() {
        return this.getMailingLists(CaseLinkType.FOR_ACTION.name());
    }

    public List<String> getForActionFunctions() {
        if (this.forActionFunctions != null) {
            return Arrays.asList(this.forActionFunctions);
        }
        return null;
    }

    public List<String> getAllForInformationMailboxes() {
        String type2 = CaseLinkType.FOR_INFORMATION.getStringType();
        HashSet<String> mailboxes = new HashSet<String>();
        if (this.favoriteMailboxes != null && !this.favoriteMailboxes.isEmpty()) {
            for (ParticipantItem item : this.favoriteMailboxes) {
                if (!type2.equals(item.getType())) continue;
                mailboxes.add(item.getId());
            }
        }
        if (this.forInformationMailboxes != null) {
            mailboxes.addAll(this.forInformationMailboxes);
        }
        for (MailingListDistributionInfo mli : this.mlInfos) {
            if (!CaseLinkType.FOR_INFORMATION.name().equals(mli.getType())) continue;
            mailboxes.addAll(mli.getMailingList().getMailboxIds());
        }
        return new ArrayList<String>(mailboxes);
    }

    @Override
    public List<String> getForInformationMailingLists() {
        return this.getMailingLists(CaseLinkType.FOR_INFORMATION.name());
    }

    protected List<String> getMailingLists(String type2) {
        ArrayList<String> result = new ArrayList<String>();
        for (MailingListDistributionInfo mli : this.mlInfos) {
            if (!type2.equals(mli.getType())) continue;
            result.add(mli.getMailingList().getId());
        }
        return result;
    }

    public List<String> getForInformationFunctions() {
        if (this.forInformationFunctions != null) {
            return Arrays.asList(this.forInformationFunctions);
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getAllParticipants() {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        res.put(CaseLinkType.FOR_ACTION.name(), this.getAllForActionMailboxes());
        res.put(CaseLinkType.FOR_INFORMATION.name(), this.getAllForInformationMailboxes());
        return res;
    }

    @Override
    public boolean isEmpty(List list) {
        return list == null || list.isEmpty();
    }

    @Override
    public boolean hasParticipants() {
        boolean res = true;
        if (this.isEmpty(this.forActionMailboxes) && this.isEmpty(this.getForActionFunctions()) && this.isEmpty(this.forActionGroups) && this.isEmpty(this.forInformationMailboxes) && this.isEmpty(this.getForInformationFunctions()) && this.isEmpty(this.forInformationGroups) && !this.hasMailingList()) {
            res = false;
        }
        return res;
    }

    private boolean hasMailingList() {
        for (MailingListDistributionInfo mli : this.mlInfos) {
            if (CaseLinkType.NONE.name().equals(mli.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean hasActionParticipants() {
        boolean res = true;
        if (this.isEmpty(this.forActionMailboxes) && this.getForActionMailingLists().isEmpty() && this.isEmpty(this.getForActionFunctions()) && this.isEmpty(this.forActionGroups)) {
            res = false;
        }
        return res;
    }

    public List<String> getForActionGroups() {
        return this.forActionGroups;
    }

    public void setForActionGroups(List<String> forActionGroups) {
        this.forActionGroups = forActionGroups;
    }

    public List<String> getForInformationGroups() {
        return this.forInformationGroups;
    }

    public void setForInformationGroups(List<String> forInformationGroups) {
        this.forInformationGroups = forInformationGroups;
    }

    @Override
    public List<MailingListDistributionInfo> getMlInfos() {
        return this.mlInfos;
    }

    @Override
    public void setMlInfos(List<MailingListDistributionInfo> mlInfos) {
        this.mlInfos = mlInfos;
    }
}

