/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModelService;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.ecm.platform.ui.web.invalidations.AutomaticDocumentBasedInvalidation;
import org.nuxeo.ecm.platform.ui.web.invalidations.DocumentContextBoundActionBean;
import org.nuxeo.runtime.api.Framework;

@Name(value="docRoutingSuggestionActions")
@Scope(value=ScopeType.CONVERSATION)
@AutomaticDocumentBasedInvalidation
public class DocumentRoutingSuggestionActionsBean
extends DocumentContextBoundActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CURRENT_DOC_ROUTING_SEARCH_ATTACHED_DOC = "CURRENT_DOC_ROUTING_SEARCH_ATTACHED_DOC";
    public static final String DOC_ROUTING_SEARCH_ALL_ROUTE_MODELS_QUERYMODEL = "DOC_ROUTING_SEARCH_ALL_ROUTE_MODELS";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;

    public DocumentModel getDocumentModel(String id) throws ClientException {
        return this.documentManager.getDocument((DocumentRef)new IdRef(id));
    }

    public List<DocumentModel> getDocumentSuggestions(Object input) throws ClientException {
        DocumentModelList docs = new ArrayList();
        try {
            QueryModelService qms = (QueryModelService)Framework.getService(QueryModelService.class);
            if (qms == null) {
                return docs;
            }
            QueryModelDescriptor qmDescriptor = qms.getQueryModelDescriptor(CURRENT_DOC_ROUTING_SEARCH_ATTACHED_DOC);
            if (qmDescriptor == null) {
                return docs;
            }
            ArrayList<String> queryParams = new ArrayList<String>();
            queryParams.add(0, String.format("%s%%", input));
            QueryModel qm = new QueryModel(qmDescriptor);
            docs = qm.getDocuments(this.documentManager, queryParams.toArray());
        }
        catch (Exception e) {
            throw new ClientException("error searching for documents", (Throwable)e);
        }
        return docs;
    }

    public List<DocumentModel> getRouteModelSuggestions(Object input) throws ClientException {
        DocumentModelList docs = new ArrayList();
        try {
            QueryModelService qms = (QueryModelService)Framework.getService(QueryModelService.class);
            if (qms == null) {
                return docs;
            }
            QueryModelDescriptor qmDescriptor = qms.getQueryModelDescriptor(DOC_ROUTING_SEARCH_ALL_ROUTE_MODELS_QUERYMODEL);
            if (qmDescriptor == null) {
                return docs;
            }
            ArrayList<String> queryParams = new ArrayList<String>();
            queryParams.add(0, String.format("%s%%", input));
            QueryModel qm = new QueryModel(qmDescriptor);
            docs = qm.getDocuments(this.documentManager, queryParams.toArray());
        }
        catch (Exception e) {
            throw new ClientException("error searching for documents", (Throwable)e);
        }
        return docs;
    }

    protected void resetBeanCache(DocumentModel newCurrentDocumentModel) {
    }
}

