/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;

public class BinaryManagerServlet
extends HttpServlet {
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final Log log = LogFactory.getLog(BinaryManagerServlet.class);
    private static final long serialVersionUID = 1L;
    private final BinaryManager binaryManager;

    public BinaryManagerServlet(BinaryManager binaryManager) {
        this.binaryManager = binaryManager;
    }

    public static String getName(BinaryManager binaryManager) {
        return BinaryManagerServlet.class.getSimpleName() + '-' + System.identityHashCode(binaryManager);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String digest = BinaryManagerServlet.getDigest(req);
            Binary binary = this.binaryManager.getBinary(digest);
            if (binary == null) {
                resp.sendError(404, "Digest '" + digest + "' not found");
            } else {
                resp.setContentType(APPLICATION_OCTET_STREAM);
                resp.setHeader("Content-Length", String.valueOf(binary.getLength()));
                ServletOutputStream out = resp.getOutputStream();
                IOUtils.copy((InputStream)binary.getStream(), (OutputStream)out);
                out.flush();
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            resp.sendError(500, e.toString());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String digest = BinaryManagerServlet.getDigest(req);
            Binary binary = this.binaryManager.getBinary((InputStream)req.getInputStream());
            if (!binary.getDigest().equals(digest)) {
                resp.sendError(409, "Digest mismatch: '" + digest + "' vs '" + binary.getDigest() + "'");
            } else {
                resp.setStatus(201);
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            resp.sendError(500, e.toString());
        }
    }

    protected static String getDigest(HttpServletRequest req) {
        String digest = req.getParameter("digest");
        if (digest == null) {
            digest = "";
        }
        return digest;
    }
}

