/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.asn1.codec.stateful.EncoderCallback;
import org.apache.directory.shared.asn1.codec.stateful.EncoderMonitor;
import org.apache.directory.shared.asn1.codec.stateful.StatefulEncoder;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.message.spi.Provider;
import org.apache.directory.shared.ldap.message.spi.ProviderEncoder;
import org.apache.directory.shared.ldap.message.spi.ProviderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwixEncoder
implements ProviderEncoder {
    private static Logger log = LoggerFactory.getLogger(TwixEncoder.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    final Provider provider;
    private EncoderCallback encodeCallback;

    public TwixEncoder(Provider provider) {
        this.provider = provider;
        this.encodeCallback = new OutputCallback();
    }

    public void encodeBlocking(Object lock, OutputStream out, Object obj) throws ProviderException {
        try {
            if (IS_DEBUG) {
                log.debug("Encoding this LdapMessage : " + obj);
            }
            this.encodeCallback.encodeOccurred(null, (Object)((LdapMessage)((Object)obj)).encode(null));
        }
        catch (EncoderException e) {
            log.error("Twix encoder failed to encode object: " + obj + ", error : " + e.getMessage());
            ProviderException pe = new ProviderException(this.provider, "Twix encoder failed to encode object: " + obj + ", error : " + e.getMessage());
            throw pe;
        }
    }

    public ByteBuffer encodeBlocking(Object obj) throws ProviderException {
        try {
            if (IS_DEBUG) {
                log.debug("Encoding this LdapMessage : " + obj);
            }
            ByteBuffer pdu = ((LdapMessage)((Object)obj)).encode(null);
            if (IS_DEBUG) {
                log.debug("Encoded PDU : " + StringTools.dumpBytes(pdu.array()));
            }
            pdu.flip();
            return pdu;
        }
        catch (EncoderException e) {
            log.error("Twix encoder failed to encode object: " + obj + ", error : " + e.getMessage());
            ProviderException pe = new ProviderException(this.provider, "Twix encoder failed to encode object: " + obj + ", error : " + e.getMessage());
            throw pe;
        }
    }

    public byte[] encodeToArray(Object obj) throws ProviderException {
        try {
            if (IS_DEBUG) {
                log.debug("Encoding this LdapMessage : " + obj);
            }
            byte[] pdu = ((LdapMessage)((Object)obj)).encode(null).array();
            if (IS_DEBUG) {
                log.debug("Encoded PDU : " + StringTools.dumpBytes(pdu));
            }
            return pdu;
        }
        catch (EncoderException e) {
            log.error("Twix encoder failed to encode object: " + obj + ", error : " + e.getMessage());
            ProviderException pe = new ProviderException(this.provider, "Twix encoder failed to encode object: " + obj + ", error : " + e.getMessage());
            throw pe;
        }
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void encode(Object obj) throws EncoderException {
        ByteBuffer encoded = this.encodeBlocking(obj);
        this.encodeCallback.encodeOccurred(null, (Object)encoded);
    }

    public void setCallback(EncoderCallback cb) {
        this.encodeCallback = cb;
    }

    public void setEncoderMonitor(EncoderMonitor monitor) {
    }

    class OutputCallback
    implements EncoderCallback {
        private WritableByteChannel channel = null;

        OutputCallback() {
        }

        public void encodeOccurred(StatefulEncoder encoder, Object encoded) {
            try {
                this.channel.write((ByteBuffer)encoded);
            }
            catch (IOException e) {
                ProviderException pe = new ProviderException(TwixEncoder.this.provider, "Twix encoder failed to encode object, error : " + e.getMessage());
                throw pe;
            }
        }

        void attach(WritableByteChannel channel) {
            this.channel = channel;
        }

        void attach(OutputStream out) {
            this.channel = Channels.newChannel(out);
        }
    }
}

