/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.classification;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.classification.api.adapter.Classification;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;

public class ClassificationTreeNode
extends DocumentTreeNodeImpl {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ClassificationTreeNode.class);

    public ClassificationTreeNode(DocumentModel document, Filter filter, Sorter sorter) {
        super(document, filter, sorter);
    }

    public void fetchChildren() {
        try {
            this.children = new LinkedHashMap();
            CoreSession session = CoreInstance.getInstance().getSession(this.sessionId);
            DocumentModelList coreChildren = session.getChildren(this.document.getRef(), null, "Read", this.filter, this.sorter);
            for (DocumentModel child : coreChildren) {
                String identifier = child.getId();
                this.children.put(identifier, new ClassificationTreeNode(child, this.filter, this.sorter));
            }
            Classification adapter = (Classification)this.document.getAdapter(Classification.class);
            DocumentModelListImpl classifChildren = new DocumentModelListImpl();
            if (adapter != null) {
                classifChildren = adapter.getClassifiedDocuments();
            }
            Collections.sort(classifChildren, this.sorter);
            for (DocumentModel child : classifChildren) {
                String identifier = child.getId();
                this.children.put(identifier, new ClassificationTreeNode(child, this.filter, this.sorter));
            }
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
    }
}

