/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service.executors;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;

public abstract class AbstractExecutor {
    public static final Pattern VALID_PARAMETER_PATTERN = Pattern.compile("[\\p{L}_0-9-.%:=/\\\\ ]+");

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("windows");
    }

    public static String getParametersString(CommandLineDescriptor cmdDesc, CmdParameters params) {
        String paramString = cmdDesc.getParametersString();
        Map<String, String> paramsValues = params.getParameters();
        paramString = AbstractExecutor.replaceParams(paramsValues, paramString);
        return paramString;
    }

    public static String[] getParametersArray(CommandLineDescriptor cmdDesc, CmdParameters params) {
        ArrayList<String> res = new ArrayList<String>();
        String[] paramsArray = cmdDesc.getParametersString().split(" ");
        Map<String, String> paramsValues = params.getParameters();
        for (String paramString : paramsArray) {
            res.add(AbstractExecutor.replaceParams(paramsValues, paramString));
        }
        return res.toArray(new String[0]);
    }

    private static String replaceParams(Map<String, String> paramsValues, String paramString) {
        for (String pname : paramsValues.keySet()) {
            String param = "#{" + pname + "}";
            if (!paramString.contains(param)) continue;
            String value = paramsValues.get(pname);
            if (!VALID_PARAMETER_PATTERN.matcher(value).matches()) {
                throw new IllegalArgumentException(String.format("'%s' contains illegal characters. It should match: %s", value, VALID_PARAMETER_PATTERN));
            }
            paramString = paramString.replace("#{" + pname + "}", String.format("\"%s\"", value));
        }
        return paramString;
    }
}

