/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.notification;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.mail.Composer;
import org.nuxeo.ecm.automation.core.mail.Mailer;
import org.nuxeo.ecm.automation.core.operations.notification.MailTemplateHelper;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Notification.SendMail", category="Notification", label="Send E-Mail", description="Send an email using the input document to the specified recipients. You can use the HTML parameter to specify whether you message is in HTML format or in plain text. Also you can attach any blob on the current document to the message by using the comma separated list of xpath expressions 'files'. If you xpath points to a blob list all blobs in the list will be attached. Return back the input document(s). If rollbackOnError is true, the whole chain will be rollbacked if an error occurs while trying to send the email (for instance if no SMTP server is configured), else a simple warning will be logged and the chain will continue.")
public class SendMail {
    protected static final Log log = LogFactory.getLog(SendMail.class);
    public static final Composer COMPOSER = new Composer();
    public static final String ID = "Notification.SendMail";
    @Context
    protected OperationContext ctx;
    @Param(name="message", widget="MailTemplate")
    protected String message;
    @Param(name="subject")
    protected String subject;
    @Param(name="from")
    protected String from;
    @Param(name="to")
    protected StringList to;
    @Param(name="HTML", required=false, values={"false"})
    protected boolean asHtml = false;
    @Param(name="files", required=false)
    protected StringList blobXpath;
    @Param(name="viewId", required=false, values={"view_documents"})
    protected String viewId = "view_documents";
    @Param(name="rollbackOnError", required=false, values={"true"})
    protected boolean rollbackOnError = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        this.send(doc);
        return doc;
    }

    protected StringList getRecipients() {
        return this.to;
    }

    protected String getContent() throws Exception {
        this.message = this.message.trim();
        if (this.message.startsWith("template:")) {
            String name = this.message.substring("template:".length()).trim();
            URL url = MailTemplateHelper.getTemplate(name);
            if (url == null) {
                throw new OperationException("No such mail template: " + name);
            }
            InputStream in = url.openStream();
            return FileUtils.read((InputStream)in);
        }
        return StringEscapeUtils.unescapeHtml((String)this.message);
    }

    protected void send(DocumentModel doc) throws Exception {
        try {
            Map map = Scripting.initBindings((OperationContext)this.ctx);
            map.put("Document", doc);
            map.put("docUrl", MailTemplateHelper.getDocumentUrl(doc, this.viewId));
            map.put("subject", this.subject);
            map.put("to", this.to);
            map.put("from", this.from);
            map.put("viewId", this.viewId);
            map.put("baseUrl", NotificationServiceHelper.getNotificationService().getServerUrlPrefix());
            map.put("Runtime", Framework.getRuntime());
            Mailer.Message msg = this.createMessage(doc, this.getContent(), map);
            msg.setFrom(this.from);
            msg.setSubject(this.subject, "UTF-8");
            for (String r : this.getRecipients()) {
                msg.addTo(r);
            }
            msg.send();
        }
        catch (Exception e) {
            if (this.rollbackOnError) {
                throw e;
            }
            log.warn((Object)String.format("An error occured while trying to execute the %s operation, see complete stack trace below. Continuing chain since 'rollbackOnError' was set to false.", ID), (Throwable)e);
        }
    }

    protected Mailer.Message createMessage(DocumentModel doc, String message, Map<String, Object> map) throws Exception {
        if (this.blobXpath == null) {
            if (this.asHtml) {
                return COMPOSER.newHtmlMessage(message, map);
            }
            return COMPOSER.newTextMessage(message, map);
        }
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (String xpath : this.blobXpath) {
            try {
                Property p = doc.getProperty(xpath);
                if (p instanceof ListProperty) {
                    for (Property pp : p) {
                        this.getBlob(pp.getValue(), blobs);
                    }
                    continue;
                }
                if (p instanceof MapProperty) {
                    for (Property sp : ((MapProperty)p).values()) {
                        this.getBlob(sp.getValue(), blobs);
                    }
                    continue;
                }
                Serializable o = p.getValue();
                if (!(o instanceof Blob)) continue;
                blobs.add((Blob)o);
            }
            catch (PropertyException pe) {
                log.error((Object)("Error while fetching blobs: " + pe.getMessage()));
                log.debug((Object)pe);
            }
        }
        return COMPOSER.newMixedMessage(message, map, this.asHtml ? "html" : "plain", blobs);
    }

    private void getBlob(Object o, List<Blob> blobs) {
        if (o instanceof List) {
            for (Object item : (List)o) {
                this.getBlob(item, blobs);
            }
        } else if (o instanceof Map) {
            for (Object item : ((Map)o).values()) {
                this.getBlob(item, blobs);
            }
        } else if (o instanceof Blob) {
            blobs.add((Blob)o);
        }
    }
}

