/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.triple;

import com.phloc.commons.collections.triple.IReadonlyTriple;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ReadonlyTriple<DATA1TYPE, DATA2TYPE, DATA3TYPE>
implements IReadonlyTriple<DATA1TYPE, DATA2TYPE, DATA3TYPE> {
    private final DATA1TYPE m_aFirst;
    private final DATA2TYPE m_aSecond;
    private final DATA3TYPE m_aThird;

    public <T2 extends DATA1TYPE, U2 extends DATA2TYPE, V2 extends DATA3TYPE> ReadonlyTriple(@Nullable T2 T2, @Nullable U2 U2, @Nullable V2 V2) {
        this.m_aFirst = T2;
        this.m_aSecond = U2;
        this.m_aThird = V2;
    }

    public ReadonlyTriple(@Nonnull IReadonlyTriple<? extends DATA1TYPE, ? extends DATA2TYPE, ? extends DATA3TYPE> iReadonlyTriple) {
        this.m_aFirst = iReadonlyTriple.getFirst();
        this.m_aSecond = iReadonlyTriple.getSecond();
        this.m_aThird = iReadonlyTriple.getThird();
    }

    @Override
    @Nullable
    public DATA1TYPE getFirst() {
        return this.m_aFirst;
    }

    @Override
    @Nullable
    public DATA2TYPE getSecond() {
        return this.m_aSecond;
    }

    @Override
    @Nullable
    public DATA3TYPE getThird() {
        return this.m_aThird;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ReadonlyTriple)) {
            return false;
        }
        ReadonlyTriple readonlyTriple = (ReadonlyTriple)object;
        return EqualsUtils.equals(this.m_aFirst, readonlyTriple.m_aFirst) && EqualsUtils.equals(this.m_aSecond, readonlyTriple.m_aSecond) && EqualsUtils.equals(this.m_aThird, readonlyTriple.m_aThird);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFirst).append(this.m_aSecond).append(this.m_aThird).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("first", this.m_aFirst).append("second", this.m_aSecond).append("third", this.m_aThird).toString();
    }

    @Nonnull
    public static <T, U, V> IReadonlyTriple<T, U, V> create(@Nullable T t, @Nullable U u, @Nullable V v) {
        return new ReadonlyTriple(t, u, v);
    }
}

