/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.executor;

import org.apache.commons.logging.Log;
import org.nuxeo.ecm.platform.importer.base.ImporterRunner;
import org.nuxeo.ecm.platform.importer.factories.DefaultDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.log.BasicLogger;
import org.nuxeo.ecm.platform.importer.log.ImporterLogger;
import org.nuxeo.ecm.platform.importer.threading.DefaultMultiThreadingPolicy;
import org.nuxeo.ecm.platform.importer.threading.ImporterThreadingPolicy;

public abstract class AbstractImporterExecutor {
    protected static ImporterLogger log;
    protected Thread executorMainThread;
    protected ImporterRunner runner;
    protected ImporterThreadingPolicy threadPolicy;
    protected ImporterDocumentModelFactory factory;

    protected abstract Log getJavaLogger();

    public ImporterLogger getLogger() {
        if (log == null) {
            log = new BasicLogger(this.getJavaLogger());
        }
        return log;
    }

    public String getStatus() {
        if (this.isRunning().booleanValue()) {
            return "Running";
        }
        return "Not Running";
    }

    public Boolean isRunning() {
        if (this.executorMainThread == null) {
            return false;
        }
        return this.executorMainThread.isAlive();
    }

    public String kill() {
        if (this.executorMainThread != null) {
            this.runner.stopImportProcrocess();
            this.executorMainThread.interrupt();
            return "Importer killed";
        }
        return "Importer is not running";
    }

    protected void startTask(ImporterRunner runner, boolean interactive) {
        this.executorMainThread = new Thread(runner);
        this.executorMainThread.setName("ImporterExecutorMainThread");
        if (interactive) {
            this.executorMainThread.run();
        } else {
            this.executorMainThread.start();
        }
    }

    protected String doRun(ImporterRunner runner, Boolean interactive) throws Exception {
        if (this.isRunning().booleanValue()) {
            throw new Exception("Task is already running");
        }
        if (interactive == null) {
            interactive = false;
        }
        this.startTask(runner, interactive);
        if (interactive.booleanValue()) {
            return "Task compeleted";
        }
        return "Started";
    }

    public ImporterThreadingPolicy getThreadPolicy() {
        if (this.threadPolicy == null) {
            this.threadPolicy = new DefaultMultiThreadingPolicy();
        }
        return this.threadPolicy;
    }

    public void setThreadPolicy(ImporterThreadingPolicy threadPolicy) {
        this.threadPolicy = threadPolicy;
    }

    public ImporterDocumentModelFactory getFactory() {
        if (this.factory == null) {
            this.factory = new DefaultDocumentModelFactory();
        }
        return this.factory;
    }

    public void setFactory(ImporterDocumentModelFactory factory) {
        this.factory = factory;
    }

    public String run(ImporterRunner runner, Boolean interactive) throws Exception {
        return this.doRun(runner, interactive);
    }
}

