/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryCachingManager;
import org.nuxeo.ecm.core.storage.sql.BinaryFileCache;
import org.nuxeo.ecm.core.storage.sql.RepositoryResolver;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class LazyBinary
extends Binary {
    private static final long serialVersionUID = 1L;
    protected boolean hasLength;
    protected transient BinaryFileCache cache;

    public LazyBinary(String digest, BinaryFileCache cache, String repo) {
        super(digest, repo);
        this.cache = cache;
    }

    protected BinaryFileCache cache() {
        if (this.cache == null) {
            if (this.repoName == null) {
                throw new UnsupportedOperationException("Cannot retrieve file cache, no repository name given");
            }
            BinaryCachingManager mgr = (BinaryCachingManager)RepositoryResolver.getBinaryManager(this.repoName);
            this.cache = mgr.fileCache();
        }
        return this.cache;
    }

    @Override
    public InputStream getStream() throws IOException {
        if (this.file == null) {
            this.file = this.cache().getFile(this.digest);
            if (this.file != null) {
                this.length = this.file.length();
                this.hasLength = true;
            }
        }
        return this.file == null ? null : new FileInputStream(this.file);
    }

    @Override
    public StreamSource getStreamSource() {
        if (this.file == null) {
            this.file = this.cache().getFile(this.digest);
            if (this.file != null) {
                this.length = this.file.length();
                this.hasLength = true;
            }
        }
        return this.file == null ? null : new FileSource(this.file);
    }

    @Override
    public long getLength() {
        if (!this.hasLength) {
            Long len = this.cache().getLength(this.digest);
            this.length = len == null ? 0L : len;
            this.hasLength = true;
        }
        return this.length;
    }
}

