/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.DataSourceFromUrl;
import org.nuxeo.runtime.api.DataSourceHelper;
import org.nuxeo.runtime.api.Framework;

public class ConnectionHelper {
    protected static final Log log = LogFactory.getLog(ConnectionHelper.class);
    protected static ThreadLocal<ConnectionInfo> threadConnectionInfo = new ThreadLocal();
    public static final String SINGLE_DS = "nuxeo.db.singleDataSource";
    public static final String EXCLUDE_DS = "nuxeo.db.singleDataSource.exclude";
    public static final int MAX_CONNECTION_TRIES = 3;

    public static Connection unwrap(Connection connection) {
        InvocationHandler handler;
        if (Proxy.isProxyClass(connection.getClass()) && (handler = Proxy.getInvocationHandler(connection)) instanceof ConnectionInvocationHandler) {
            ConnectionInvocationHandler h = (ConnectionInvocationHandler)handler;
            connection = h.connectionInfo.connection;
        }
        try {
            Method m = connection.getClass().getMethod("getInnermostDelegate", new Class[0]);
            m.setAccessible(true);
            Connection delegate = (Connection)m.invoke((Object)connection, new Object[0]);
            if (delegate == null) {
                log.error((Object)"Cannot access underlying connection, you must use accessToUnderlyingConnectionAllowed=true in the pool configuration");
            } else {
                connection = delegate;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connection;
    }

    public static boolean useSingleConnection(String dataSourceName) {
        if (dataSourceName != null) {
            String excludes = Framework.getProperty(EXCLUDE_DS);
            if ("*".equals(excludes)) {
                return false;
            }
            if (!StringUtils.isBlank((String)excludes)) {
                for (String exclude : excludes.split("[, ] *")) {
                    if (!dataSourceName.equals(exclude) && !dataSourceName.equals(DataSourceHelper.getDataSourceJNDIName(exclude))) continue;
                    return false;
                }
            }
        }
        return !StringUtils.isBlank((String)Framework.getProperty(SINGLE_DS));
    }

    public static String getPseudoDataSourceNameForRepository(String repositoryName) {
        return "repository_" + repositoryName;
    }

    public static Connection getConnection(String dataSourceName) throws SQLException {
        return ConnectionHelper.getConnection(dataSourceName, false);
    }

    public static Connection getConnection(String dataSourceName, boolean noSharing) throws SQLException {
        if (!ConnectionHelper.useSingleConnection(dataSourceName)) {
            return null;
        }
        return ConnectionHelper.getConnection(noSharing);
    }

    protected static Connection getConnection(boolean noSharing) throws SQLException {
        String dataSourceName = Framework.getProperty(SINGLE_DS);
        if (StringUtils.isBlank((String)dataSourceName)) {
            return null;
        }
        if (noSharing) {
            DataSource dataSource = ConnectionHelper.getDataSource(dataSourceName);
            return ConnectionHelper.getConnection(dataSource);
        }
        ConnectionInfo info = ConnectionInfo.getCurrent();
        if (info == null) {
            DataSource dataSource = ConnectionHelper.getDataSource(dataSourceName);
            info = new ConnectionInfo(ConnectionHelper.getConnection(dataSource));
        }
        return info.getNewConnection();
    }

    private static DataSource getDataSource(String dataSourceName) throws SQLException {
        if (Framework.isTestModeSet()) {
            String url = Framework.getProperty("nuxeo.test.vcs.url");
            String user = Framework.getProperty("nuxeo.test.vcs.user");
            String password = Framework.getProperty("nuxeo.test.vcs.password");
            if (url != null && user != null) {
                return new DataSourceFromUrl(url, user, password);
            }
        }
        try {
            return DataSourceHelper.getDataSource(dataSourceName);
        }
        catch (NamingException e) {
            throw new SQLException("Cannot find datasource: " + dataSourceName, e);
        }
    }

    public static int countConnectionReferences() {
        ConnectionInfo info = ConnectionInfo.getCurrent();
        return info == null ? 0 : info.ref;
    }

    public static int clearConnectionReferences() {
        int n = 0;
        while (ConnectionHelper.countConnectionReferences() > 0) {
            ++n;
            try {
                ConnectionInfo.getCurrent().unref();
            }
            catch (SQLException e) {
                log.error((Object)"Error closing connection", (Throwable)e);
            }
        }
        return n;
    }

    private static Connection getConnection(DataSource dataSource) throws SQLException {
        int tryNo = 0;
        while (true) {
            try {
                return dataSource.getConnection();
            }
            catch (SQLException e) {
                if (tryNo >= 3) {
                    throw e;
                }
                if (e.getErrorCode() != 12519) {
                    throw e;
                }
                log.warn((Object)String.format("Connections open too fast, retrying in %ds: %s", tryNo, e.getMessage().replace("\n", " ")));
                try {
                    Thread.sleep(1000 * tryNo);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                ++tryNo;
                continue;
            }
            break;
        }
    }

    protected static class ConnectionInvocationHandler
    implements InvocationHandler {
        public final ConnectionInfo connectionInfo;
        public boolean closed;

        public ConnectionInvocationHandler(ConnectionInfo connectionInfo) {
            this.connectionInfo = connectionInfo;
            connectionInfo.ref();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if (name.equals("isClosed")) {
                return this.closed;
            }
            if (this.closed) {
                return new SQLException("Connection is closed", "08003");
            }
            if (name.equals("close")) {
                return this.close();
            }
            try {
                return method.invoke((Object)this.connectionInfo.connection, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        protected Object close() throws SQLException {
            this.closed = true;
            this.connectionInfo.unref();
            return null;
        }
    }

    protected static class ConnectionInfo {
        public final Connection connection;
        protected int ref;
        protected Thread thread;
        private static final int LEAK_REF_MIN = 20;
        private static final int LEAK_REF_MAX = 25;
        protected List<Exception> stacktraces;

        public static ConnectionInfo getCurrent() {
            return threadConnectionInfo.get();
        }

        public ConnectionInfo(Connection connection) {
            this.connection = connection;
            threadConnectionInfo.set(this);
            this.thread = Thread.currentThread();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opening single connection to: " + Framework.getProperty(ConnectionHelper.SINGLE_DS) + " " + this + " " + connection));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Opening single connection stacktrace", (Throwable)new Exception("debug"));
            }
        }

        public void ref() {
            ++this.ref;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reference added (" + this.ref + ") for " + this));
            }
            if (this.ref >= 20 && this.ref < 25) {
                if (this.stacktraces == null) {
                    this.stacktraces = new ArrayList<Exception>();
                }
                this.stacktraces.add(new Exception(new Date().toString()));
                if (this.ref == 24) {
                    log.error((Object)"Probable leak of connections, listing the last callers:");
                    for (Exception e : this.stacktraces) {
                        log.error((Object)"Caller", (Throwable)e);
                    }
                    this.stacktraces = null;
                }
            }
        }

        public void unref() throws SQLException {
            --this.ref;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reference removed (" + this.ref + ") for " + this));
            }
            if (this.ref == 0) {
                Thread currentThread = Thread.currentThread();
                if (this.thread == currentThread) {
                    threadConnectionInfo.remove();
                } else {
                    log.error((Object)("Single connection was acquired in thread " + this.thread.getName() + " but is closed in thread " + currentThread.getName() + ": " + this), (Throwable)new Exception());
                }
                this.connection.close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Closing single connection to: " + Framework.getProperty(ConnectionHelper.SINGLE_DS) + " " + this));
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Closing single connection stacktrace", (Throwable)new Exception("debug"));
                }
            }
        }

        public Connection getNewConnection() {
            return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(this));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this));
        }
    }
}

