/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLink;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLinkComputer;
import org.nuxeo.runtime.api.Framework;

@XObject(value="loginScreenConfig")
public class LoginScreenConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNodeList(value="loginProviders/loginProvider", type=ArrayList.class, componentType=LoginProviderLink.class)
    protected List<LoginProviderLink> providers;
    protected String headerStyle;
    protected String footerStyle;
    @XNode(value="newsIframeUrl")
    protected String newsIframeUrl = "https://www.nuxeo.com/embedded/dm-login";
    protected String bodyBackgroundStyle;
    protected String loginBoxBackgroundStyle;
    @XNode(value="loginBoxWidth")
    protected String loginBoxWidth;
    protected String logoUrl;
    @XNode(value="logoAlt")
    protected String logoAlt;
    @XNode(value="logoWidth")
    protected String logoWidth;
    @XNode(value="logoHeight")
    protected String logoHeight;

    public List<LoginProviderLink> getProviders() {
        return this.providers;
    }

    public void setProviders(List<LoginProviderLink> providers) {
        this.providers = providers;
    }

    public LoginProviderLink getProvider(String name) {
        if (this.getProviders() == null) {
            return null;
        }
        for (LoginProviderLink provider : this.getProviders()) {
            if (!name.equals(provider.getName())) continue;
            return provider;
        }
        return null;
    }

    protected void merge(LoginScreenConfig newConfig) {
        if (newConfig.newsIframeUrl != null) {
            this.newsIframeUrl = newConfig.newsIframeUrl;
        }
        if (newConfig.headerStyle != null) {
            this.headerStyle = newConfig.headerStyle;
        }
        if (newConfig.footerStyle != null) {
            this.footerStyle = newConfig.footerStyle;
        }
        if (newConfig.bodyBackgroundStyle != null) {
            this.bodyBackgroundStyle = newConfig.bodyBackgroundStyle;
        }
        if (newConfig.loginBoxBackgroundStyle != null) {
            this.loginBoxBackgroundStyle = newConfig.loginBoxBackgroundStyle;
        }
        if (newConfig.loginBoxWidth != null) {
            this.loginBoxWidth = newConfig.loginBoxWidth;
        }
        if (newConfig.logoAlt != null) {
            this.logoAlt = newConfig.logoAlt;
        }
        if (newConfig.logoHeight != null) {
            this.logoHeight = newConfig.logoHeight;
        }
        if (newConfig.logoUrl != null) {
            this.logoUrl = newConfig.logoUrl;
        }
        if (newConfig.logoWidth != null) {
            this.logoWidth = newConfig.logoWidth;
        }
        if (this.providers == null) {
            this.providers = newConfig.providers;
        } else if (newConfig.providers != null && newConfig.providers.size() > 0) {
            for (LoginProviderLink link : newConfig.providers) {
                int idx = this.providers.indexOf(link);
                if (idx >= 0) {
                    if (link.remove) {
                        this.providers.remove(idx);
                        continue;
                    }
                    this.providers.get(idx).merge(link);
                    continue;
                }
                this.providers.add(link);
            }
        }
    }

    public void registerLoginProvider(String name, String iconUrl, String link, String label, String description, LoginProviderLinkComputer computer) {
        LoginProviderLink existingProvider;
        LoginProviderLink newProvider = new LoginProviderLink();
        newProvider.name = name;
        newProvider.iconPath = iconUrl;
        newProvider.link = link;
        newProvider.label = label;
        newProvider.description = description;
        if (computer != null) {
            newProvider.urlComputer = computer;
        }
        if ((existingProvider = this.getProvider(name)) != null) {
            existingProvider.merge(newProvider);
        } else {
            if (this.providers == null) {
                this.providers = new ArrayList<LoginProviderLink>();
            }
            this.providers.add(newProvider);
        }
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    public String getFooterStyle() {
        return this.footerStyle;
    }

    public String getBodyBackgroundStyle() {
        return this.bodyBackgroundStyle;
    }

    public String getLoginBoxBackgroundStyle() {
        return this.loginBoxBackgroundStyle;
    }

    public String getLoginBoxWidth() {
        return this.loginBoxWidth;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public String getLogoAlt() {
        return this.logoAlt;
    }

    public String getLogoWidth() {
        return this.logoWidth;
    }

    public String getLogoHeight() {
        return this.logoHeight;
    }

    public boolean getDisplayNews() {
        return this.newsIframeUrl != null && !this.newsIframeUrl.isEmpty();
    }

    @XNode(value="headerStyle")
    public void setHeaderStyle(String headerStyle) {
        this.headerStyle = Framework.expandVars((String)headerStyle);
    }

    @XNode(value="footerStyle")
    public void setFooterStyle(String footerStyle) {
        this.footerStyle = Framework.expandVars((String)footerStyle);
    }

    @XNode(value="bodyBackgroundStyle")
    public void setBodyBackgroundStyle(String bodyBackgroundStyle) {
        this.bodyBackgroundStyle = Framework.expandVars((String)bodyBackgroundStyle);
    }

    @XNode(value="loginBoxBackgroundStyle")
    public void setLoginBoxBackgroundStyle(String loginBoxBackgroundStyle) {
        this.loginBoxBackgroundStyle = Framework.expandVars((String)loginBoxBackgroundStyle);
    }

    @XNode(value="logoUrl")
    public void setLogoUrl(String logoUrl) {
        this.logoUrl = Framework.expandVars((String)logoUrl);
    }

    public String getNewsIframeUrl() {
        return this.newsIframeUrl;
    }
}

