/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event;

import java.io.Serializable;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public abstract class AbstractDraftListener {
    protected abstract Log getLog();

    protected abstract String getEventName();

    public void handleEvent(Event event) throws ClientException {
        if (!this.getEventName().equals(event.getName())) {
            this.getLog().warn((Object)("DraftUpdatedListener called on a non DraftUpdatedListener event: " + event));
            return;
        }
        DocumentEventContext docCtx = null;
        Principal principal = null;
        if (!(event.getContext() instanceof DocumentEventContext)) {
            this.getLog().warn((Object)("DraftUpdatedListener called with non DocumentEventContext context: " + event.getContext()));
            return;
        }
        docCtx = (DocumentEventContext)event.getContext();
        principal = docCtx.getPrincipal();
        CoreSession session = docCtx.getCoreSession();
        DocumentModel envelopeDM = docCtx.getSourceDocument();
        if (envelopeDM == null) {
            return;
        }
        if (!envelopeDM.hasFacet("Distributable") || envelopeDM.hasFacet("CaseGroupable")) {
            return;
        }
        Case envelope = (Case)envelopeDM.getAdapter(Case.class);
        if (envelope == null) {
            return;
        }
        CaseItem item = envelope.getFirstItem(session);
        if (item == null) {
            return;
        }
        DocumentModel firstDoc = item.getDocument();
        CaseLink draft = (CaseLink)docCtx.getProperties().get("eventContextDraft");
        this.updateDraft(draft.getDocument(), firstDoc, envelopeDM, principal);
        session.saveDocument(draft.getDocument());
    }

    protected void updateDraft(DocumentModel draft, DocumentModel firstDoc, DocumentModel envelope, Principal principal) throws ClientException {
        draft.setPropertyValue("cmct:sendersContacts", firstDoc.getPropertyValue("cmct:sendersContacts"));
        draft.setPropertyValue("cmct:participantsContacts", firstDoc.getPropertyValue("cmct:participantsContacts"));
        draft.setPropertyValue("cslk:sender", (Serializable)((Object)principal.getName()));
    }
}

