/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.exception.CaseManagementException;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.SimplePrincipal;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class SuccessLoginListener
implements EventListener {
    private static final Log log = LogFactory.getLog(SuccessLoginListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) throws ClientException {
        block12: {
            boolean isNewTransactionStarted;
            block11: {
                CoreSession session = null;
                isNewTransactionStarted = false;
                try {
                    MailboxManagementService nxcService = (MailboxManagementService)Framework.getService(MailboxManagementService.class);
                    if (nxcService == null) {
                        throw new CaseManagementException("CorrespondenceService not found.");
                    }
                    if (!TransactionHelper.isTransactionActive()) {
                        isNewTransactionStarted = TransactionHelper.startTransaction();
                    }
                    SimplePrincipal principal = (SimplePrincipal)event.getContext().getPrincipal();
                    session = this.getCoreSession();
                    if (!nxcService.hasUserPersonalMailbox(session, principal.getName())) {
                        nxcService.createPersonalMailboxes(session, principal.getName());
                    }
                    if (session == null) break block11;
                }
                catch (Exception e) {
                    log.error((Object)"Error during personal mailbox creation.", (Throwable)e);
                    break block12;
                }
                finally {
                    if (session != null) {
                        Repository.close(session);
                    }
                    if (isNewTransactionStarted) {
                        TransactionHelper.commitOrRollbackTransaction();
                    }
                }
                Repository.close((CoreSession)session);
            }
            if (isNewTransactionStarted) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    protected CoreSession getCoreSession() throws Exception {
        RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
        if (mgr == null) {
            throw new ClientException("Cannot find RepositoryManager");
        }
        Repository repo = mgr.getDefaultRepository();
        return repo.open();
    }
}

